﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Projects;
    using ToolDevelopmentKit;

    internal class NameResolverSelector : ComponentSetupSelector
    {
        public NameResolverSelector(ComponentDictionary componentDictionary)
        {
            Ensure.Argument.NotNull(componentDictionary);

            this.AddSetup(typeof(StreamSound), new SoundNameResolver<StreamSoundBase>(componentDictionary));
            this.AddSetup(typeof(WaveSound), new SoundNameResolver<WaveSoundBase>(componentDictionary));
            this.AddSetup(typeof(SequenceSound), new SequenceSoundNameResolver(componentDictionary));
            this.AddSetup(typeof(SoundSetBank), new SoundSetBankNameResolver(componentDictionary));
            this.AddSetup(typeof(WaveSoundSetBase), new WaveSoundSetNameResolver(componentDictionary));
            this.AddSetup(typeof(GroupBase), new GroupNameResolver(componentDictionary));
        }
    }
}
