﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    internal class GroupItemGenerator : ComponentSetup<SoundArchiveContext, GroupBase>
    {
        /// <summary>
        /// コンポーネントを処理します。
        /// </summary>
        /// <param name="context">コンバートコンテキストを指定します。</param>
        /// <param name="component">コンポーネントを指定します。</param>
        protected sealed override void RunInternal(SoundArchiveContext context, GroupBase component)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(component);

            GenerateGroupWaveArchive(context, component);
        }

        /// <summary>
        /// グループの共有波形アーカイブを作成します。
        /// </summary>
        /// <remarks>
        /// 波形アーカイブの統合はここでは行われず、WaveSoundSetItemGenerator、
        /// SoundSetBankItemGenerator にて行われます。
        /// </remarks>
        /// <param name="context">サウンドアーカイブコンテキストを指定します。</param>
        /// <param name="group">対象となるグループを指定します。</param>
        private void GenerateGroupWaveArchive(SoundArchiveContext context, GroupBase group)
        {
            Assertion.Argument.NotNull(context);
            Assertion.Argument.NotNull(group);

            if (!group.IsEmbeddedWaveSharing(context.Traits.IsWaveSound2BinaryEnabled)) { return; }

            WaveArchiveBase waveArchive = new WaveArchiveBase()
            {
                Name = string.Format(
                    "{0}_WaveArchive{1}",
                    group.Name, SoundArchiveContext.AutoGeneratedNamePostfix),
            };

            waveArchive.GetAttachedGroups().Add(group);
            group.SetTargetWaveArchive(waveArchive);

            waveArchive.ID = new BinaryItemID(ItemType.WaveArchive, (uint)context.WaveArchives.Count);
            context.WaveArchives.Add(waveArchive);
        }
    }
}
