﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.SoundFoundation.Core;

    /// <summary>
    /// Waveエンコーダを生成します。
    /// </summary>
    public class NintendoWareWaveEncoderFactory : ObjectAggregateFactory<string, NintendoWareWaveEncoder>
    {
        private static NintendoWareWaveEncoderFactory instance = null;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        private NintendoWareWaveEncoderFactory()
        {
            this.Factories.Add(
                Encoding.Pcm,
                new ObjectFactoryDelegation<string, NintendoWareWaveEncoder>(
                    enoding => new NintendoWareLinearPcmEncoder()
                    )
                );

            this.Factories.Add(
                Encoding.DspAdpcm,
                new ObjectFactoryDelegation<string, NintendoWareWaveEncoder>(
                    enoding => new NintendoWareDspAdpcmEncoder()
                    )
                );

            this.Factories.Add(
                Encoding.PcmStream,
                new ObjectFactoryDelegation<string, NintendoWareWaveEncoder>(
                    enoding => new NintendoWareLinearPcmStreamEncoder()
                    )
                );

            this.Factories.Add(
                Encoding.DspAdpcmStream,
                new ObjectFactoryDelegation<string, NintendoWareWaveEncoder>(
                    enoding => new NintendoWareDspAdpcmStreamEncoder()
                    )
                );

            // TODO : ★IMAADPCM対応。
        }

        /// <summary>
        /// インスタンスを取得します。
        /// </summary>
        public static NintendoWareWaveEncoderFactory Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = new NintendoWareWaveEncoderFactory();
                }

                return instance;
            }
        }
    }
}
