﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class TreeSurveyer : ITreeSurveyer
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Point GetDivergePoint(int indentLength, int height)
        {
            return new Point(indentLength / 2, height / 2);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        Rectangle ITreeSurveyer.GetExpanderBounds(int indentLength, int height)
        {
            Point point = GetDivergePoint(indentLength, height);
            return new Rectangle(point.X - 4, point.Y - 4, 8, 8);
        }
    }
}
