﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class TreePart : ITreePart
    {
        private string _Name = null;
        private Rectangle _Bounds;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public TreePart(string name, Rectangle bounds)
        {
            _Name = name;
            _Bounds = bounds;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string Name
        {
            get { return _Name; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Rectangle Bounds
        {
            get { return _Bounds; }
        }
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class TreeSubItem : ITreeSubItem
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        string ITreeSubItem.Name
        {
            get { return String.Empty; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        ITreePart[] ITreeSubItem.GetParts(TreeItemDrawDescriptor desc)
        {
            Size size;
            int width = 0;
            string caption = desc.Parameters["Caption"];

            size = Size.Truncate(desc.Gc.MeasureString(caption, desc.Font));
            width = size.Width + 1;     //+1しないと描画に必要な幅にならない

            if (width < 16)
            {
                width = 16;
            }

            return new TreePart[] {
                new TreePart( "Icon",    new Rectangle(  0, 0,    16, 16)),
                new TreePart( "Caption", new Rectangle( 18, 0, width, 16)),
            };
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        Rectangle ITreeSubItem.BoundsForSelected
        {
            get { return new Rectangle(18, 0, 32, 16); }
        }
    }
}
