﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public interface IListSubItem
    {
        string Name { get; }
        bool EditByKey { get; }
        Dictionary<string, object> PartParameters { get; }

        IListPart[] GetParts(ListDrawDescriptor desc);
        //string RepresentativeEditorName { get; }
        string RepresentativeEditorName(bool immediateEdit);
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public interface IListSubItemArgument
    {
        IListDrawerArgument DrawerArgument { get; }
        IInplaceEditorArgument EditorArgument { get; } //エディタ用引数
    }

    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public interface IListPart
    {
        string DrawerName { get; }
        string EditorName { get; }
        string EditorNameByDoubleClick { get; }

        Rectangle Bounds { get; }
        ListPartActions Action { get; }

        bool ItemSelectable { get; }
        bool ItemDragable { get; }
        bool DoubleClickable { get; }

        bool EditByClick { get; }
        bool EditByClickOnCaret { get; }
        bool EditByDoubleClick { get; }
    }
}
