﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public partial class EmbeddedPage : NUserControl, IEmbeddedPage
    {
        #region ** パラメータ

        private string _pageID = "";
        private bool _windowActive = false;
        private bool _active = false;

        #endregion

        protected EmbeddedPage(string pageID)
        {
            if (null == pageID) { throw new ArgumentNullException("pageID"); }

            InitializeComponent();

            _pageID = pageID;
        }

        private EmbeddedPage() : this("") { }

        #region ** プロパティ

        [DefaultValue("")]
        public string PageID
        {
            get { return _pageID; }
        }

        [DefaultValue("")]
        public new virtual string Text
        {
            get { return base.Text; }
            set
            {
                if (null == value)
                {
                    base.Text = "";
                    return;
                }
                base.Text = value;
            }
        }

        [ReadOnly(true)]
        public bool WindowActive
        {
            get { return _windowActive; }
            set
            {
                if (value == _windowActive) { return; }

                _windowActive = value;
                OnWindowActiveChanged(new EventArgs());
            }
        }

        [ReadOnly(true)]
        public bool Active
        {
            get { return _active; }
            set
            {
                if (value == _active) { return; }

                _active = value;
                OnActiveChanged(new EventArgs());
            }
        }

        #endregion

        #region ** プロパティのオーバーライド

        protected override Size DefaultSize
        {
            get { return new Size(240, 300); }
        }

        #endregion

        #region ** プロパティの再定義

        [DefaultValue(typeof(Size), "240, 300")]
        protected new Size MinimumSize
        {
            get { return base.MinimumSize; }
            set { base.MinimumSize = value; }
        }

        #endregion

        #region ** イベントハンドラ

        protected virtual void OnWindowActiveChanged(EventArgs e) { }

        protected virtual void OnActiveChanged(EventArgs e) { }

        #endregion
    }

    public interface IEmbeddedPage
    {
        #region ** プロパティ

        string PageID { get; }

        bool WindowActive { get; set; }

        bool Active { get; set; }

        #endregion
    }
}
