﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.Core;

namespace NintendoWare.SoundFoundation.Windows.Forms
{
    public class ComponentVelocityRegionCollection : Collection<IVelocityRegion>, IVelocityRegionCollection
    {
        public event NotifyCollectionChangedEventHandler CollectionChanged;
        private bool _EventFlag = true;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        IEnumerator<IVelocityRegion> IEnumerable<IVelocityRegion>.GetEnumerator()
        {
            return this.GetEnumerator();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool IsReadOnly
        {
            get { return ((IList<ITreeObject>)this).IsReadOnly; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int Count
        {
            get { return base.Count; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new IVelocityRegion this[int index]
        {
            get { return base[index]; }
            set { base[index] = value; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new int IndexOf(IVelocityRegion region)
        {
            return base.IndexOf(region);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new bool Contains(IVelocityRegion region)
        {
            return base.Contains(region);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public new void CopyTo(IVelocityRegion[] array, int index)
        {
            base.CopyTo(array, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void SuspendVelocityRegionCollectionEvent()
        {
            _EventFlag = false;
        }

        public void ResumeVelocityRegionCollectionEvent()
        {
            _EventFlag = true;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ComponentVelocityRegion PrevChild(ComponentVelocityRegion region)
        {
            ComponentVelocityRegion prevRegion = null;

            int index = IndexOf(region) - 1;
            if (0 <= index && index < Count)
            {
                prevRegion = (ComponentVelocityRegion)this[index];
            }

            return prevRegion;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public ComponentVelocityRegion NextChild(ComponentVelocityRegion region)
        {
            ComponentVelocityRegion nextRegion = null;

            int index = IndexOf(region) + 1;
            if (0 <= index && index < Count)
            {
                nextRegion = (ComponentVelocityRegion)this[index];
            }

            return nextRegion;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void ClearItems()
        {
            base.ClearItems();
            OnCollectionChanged(CreateEventArgsReset());
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void InsertItem(int index, IVelocityRegion region)
        {
            base.InsertItem(index, region);
            OnCollectionChanged(CreateEventArgsAdd(region, IndexOf(region)));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected override void RemoveItem(int index)
        {
            IVelocityRegion region = this[index];

            base.RemoveItem(index);
            OnCollectionChanged(CreateEventArgsRemove(region, index));
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsReset()
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Reset);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsAdd(IVelocityRegion region, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Add, region, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected NotifyCollectionChangedEventArgs CreateEventArgsRemove(IVelocityRegion region, int index)
        {
            return new NotifyCollectionChangedEventArgs
                (NotifyCollectionChangedAction.Remove, region, index);
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        protected void OnCollectionChanged(NotifyCollectionChangedEventArgs e)
        {
            if (_EventFlag == true)
            {
                if (CollectionChanged != null)
                {
                    CollectionChanged(this, e);
                }
            }
        }
    }
}
