﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundFoundation.Windows.CommandBars
{
    /// <summary>
    /// コマンドバーアイテムをグループ化します。
    /// </summary>
    public class CommandBarItemGroup
    {
        private string _name = string.Empty;
        private CommandBarItemCollection _items = new CommandBarItemCollection();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="name">グループの名前。</param>
        public CommandBarItemGroup(string name)
        {
            if (null == name) { throw new ArgumentNullException("name"); }
            _name = name;
        }

        /// <summary>
        /// グループの名前を取得します。
        /// </summary>
        public string Name
        {
            get { return _name; }
        }

        /// <summary>
        /// コマンドバーアイテムのコレクションを取得します。
        /// </summary>
        public CommandBarItemCollection Items
        {
            get { return _items; }
        }

        /// <summary>
        /// URI からアイテムを検索します。
        /// </summary>
        /// <param name="uri">アイテムの URI。</param>
        /// <returns>該当するアイテム。</returns>
        public IEnumerable<CommandBarItem> FindItems(string uri)
        {
            foreach (CommandBarItem item in _items)
            {

                if (uri == item.Uri)
                {
                    yield return item;
                }

                if (item is CommandBarPopupItem)
                {

                    foreach (CommandBarItem itemChild in item.FindItems(uri))
                    {
                        yield return itemChild;
                    }

                }

            }
        }
    }
}
