﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.Core;

namespace NintendoWare.SoundFoundation.Projects
{
    ///-----------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class SoundDocumentBindingEventArgs : RoutingEventArgs
    {
        private SoundDocument _Document = null;
        private SoundDocumentChangedAction _Action = SoundDocumentChangedAction.Added;

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SoundDocumentBindingEventArgs(SoundDocument document, SoundDocumentChangedAction action)
            : base(new UpdateDocumentBindingEvent())
        {
            if (null == document) { throw new ArgumentNullException("document"); }
            _Document = document;
            _Action = action;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundDocument Document
        {
            get { return _Document; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Component[] Components
        {
            get { return Document.TopComponents; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public SoundDocumentChangedAction Action
        {
            get { return _Action; }
        }
    }

    /// <summary>
    /// ドキュメント変更の種別。
    /// </summary>
    public enum SoundDocumentChangedAction
    {
        Added,
        Removed,
    }
}
