﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using NintendoWare.SoundFoundation.Core;

namespace NintendoWare.SoundFoundation.Projects
{
    ///-----------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class QuerySoundProjectItemBindingEventArgs : BooleanResultEventArgs
    {
        private Component component = null;
        private HashSet<Component> bindingComponents = new HashSet<Component>();

        ///--------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public QuerySoundProjectItemBindingEventArgs(Component component)
            : base(new QuerySoundProjectItemBindingEvent())
        {
            if (null == component) { throw new ArgumentNullException("component"); }
            this.component = component;
        }

        public Component Component
        {
            get { return this.component; }
        }

        public HashSet<Component> BindingComponents
        {
            get { return this.bindingComponents; }
        }

        public override bool Result
        {
            get { return (0 < this.bindingComponents.Count); }
            set { base.Result = value; }
        }
    }

}
