﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using System;

    public class ListColumnOutput : ICloneable
    {
        public ListColumnOutput()
        {
            this.Name = string.Empty;
            this.IsOutput = false;
        }

        public string Name { get; set; }

        public bool IsOutput { get; set; }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        public ListColumnOutput Clone()
        {
            ListColumnOutput clone = new ListColumnOutput()
            {
                Name = string.Copy(this.Name),
                IsOutput = IsOutput,
            };

            return clone;
        }

        /// <summary>
        /// 値を比較します。
        /// </summary>
        public override bool Equals(Object obj)
        {
            if (obj is ListColumnOutput)
            {
                ListColumnOutput other = obj as ListColumnOutput;
                if (this.Name != other.Name ||
                    this.IsOutput != other.IsOutput)
                {
                    return false;
                }

                return true;
            }
            else
            {
                return false;
            }
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        /// <summary>
        /// インスタンスのコピーを作成します。
        /// </summary>
        /// <returns>コピーされた新しいオブジェクトを返します。</returns>
        object ICloneable.Clone()
        {
            return this.Clone();
        }
    }
}
