﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    /// <summary>
    /// サウンドアーカイブの出力設定です。
    /// </summary>
    public enum SoundArchiveOutputTypes
    {
        /// <summary>
        /// 出力しない
        /// </summary>
        None = 0,

        /// <summary>
        /// サウンドアーカイブ
        /// </summary>
        SoundArchive = 1,

        /// <summary>
        /// 追加サウンドアーカイブ
        /// </summary>
        AddonSoundArchive = 2,
    }

    public static class SoundArchiveOutputTypesEx
    {
        public static string ToText(this SoundArchiveOutputTypes value)
        {
            switch (value)
            {
                case SoundArchiveOutputTypes.None: return "None";
                case SoundArchiveOutputTypes.SoundArchive: return "SoundArchive";
                case SoundArchiveOutputTypes.AddonSoundArchive: return "AddonSoundArchive";
            }
            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static SoundArchiveOutputTypes Parse(string text)
        {
            switch (text)
            {
                case "None": return SoundArchiveOutputTypes.None;
                case "SoundArchive": return SoundArchiveOutputTypes.SoundArchive;
                case "AddonSoundArchive": return SoundArchiveOutputTypes.AddonSoundArchive;
            }
            throw new ArgumentException("invalid text.");
        }
    }
}
