﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using System.Diagnostics;
    using NintendoWare.SoundFoundation.Core;
    using NintendoWare.SoundFoundation.Core.Parameters;

    public static class DecayCurve3DEx
    {
        public static string ToText(this DecayCurve3D value)
        {
            switch (value)
            {
                case DecayCurve3D.Log:
                    return "Log";

                case DecayCurve3D.Linear:
                    return "Linear";

            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static DecayCurve3D Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Log":
                    return DecayCurve3D.Log;

                case "Linear":
                    return DecayCurve3D.Linear;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
