﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.ToolDevelopmentKit;
    using LegacyFormat = NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat;

    public class SoundProjectRvlDocumentReader : IDocumentReader
    {
        /// <summary>
        /// 対応するドキュメントの種類を取得します。
        /// </summary>
        public string DocumentTypeName
        {
            get { return Platforms.Rvl.SoundProjectDocument; }
        }

        public bool IsSupported(IStreamResource resource)
        {
            try
            {
                LegacyFormat.Nw4rSoundMakerProject legacyProjectXml = this.ReadFile(resource);
                return (legacyProjectXml != null);
            }
            catch
            {
                return false;
            }
        }

        public void Read(IStreamResource resource, Document document)
        {
            Ensure.Argument.NotNull(resource);
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is SoundProjectRvlDocument);

            SoundProjectRvlDocument soundProjectDocument = document as SoundProjectRvlDocument;
            soundProjectDocument.Project = this.ReadFile(resource);
        }

        private LegacyFormat.Nw4rSoundMakerProject ReadFile(IStreamResource resource)
        {
            Ensure.Argument.NotNull(resource);
            Ensure.Argument.True(resource is FileResource);

            LegacyFormat.Nw4rSoundMakerProject legacyProjectXml = new LegacyFormat.Nw4rSoundMakerProject();
            legacyProjectXml.Load(resource.Key);

            return legacyProjectXml;
        }
    }
}
