﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Documents;
    using NintendoWare.ToolDevelopmentKit;
    using LegacyFormat = NintendoWare.SoundFoundation.Legacies.FileFormat.Nw4rFileFormat;

    public class BankRvlDocumentReader : IDocumentReader
    {
        /// <summary>
        /// 対応するドキュメントの種類を取得します。
        /// </summary>
        public string DocumentTypeName
        {
            get { return Platforms.Rvl.BankDocument; }
        }

        public bool IsSupported(IStreamResource resource)
        {
            try
            {
                LegacyFormat.Nw4rXmlBank legacyBankXml = this.ReadFile(resource);
                return (legacyBankXml != null);
            }
            catch
            {
                return false;
            }
        }

        public void Read(IStreamResource resource, Document document)
        {
            Ensure.Argument.NotNull(resource);
            Ensure.Argument.True(resource is FileResource);
            Ensure.Argument.True(document is BankRvlDocument);

            BankRvlDocument bankDocument = document as BankRvlDocument;
            bankDocument.Bank = this.ReadFile(resource);
        }

        private LegacyFormat.Nw4rXmlBank ReadFile(IStreamResource resource)
        {
            Ensure.Argument.NotNull(resource);
            Ensure.Argument.True(resource is FileResource);

            LegacyFormat.Nw4rXmlBank legacyBankXml = new LegacyFormat.Nw4rXmlBank();
            legacyBankXml.Load(resource.Key);

            return legacyBankXml;
        }
    }
}
