﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Projects
{
    public class ComponentID
    {
        private Guid _Value;

        ///--------------------------------
        /// <summary>
        /// 空のComponentIDの取得
        /// </summary>
        public static ComponentID Empty
        {
            get { return new ComponentID(Guid.Empty); }
        }

        ///--------------------------------
        /// <summary>
        /// ComponentIDの取得
        /// </summary>
        public static ComponentID Create()
        {
            return new ComponentID(Guid.NewGuid());
        }

        public static bool operator ==(ComponentID valueA, ComponentID valueB)
        {
            return valueA.Value == valueB.Value;
        }

        public static bool operator !=(ComponentID valueA, ComponentID valueB)
        {
            return valueA.Value != valueB.Value;
        }

        public override int GetHashCode()
        {
            return base.GetHashCode();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Guid Value
        {
            get
            {
                return this._Value;
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        internal ComponentID(Guid value)
        {
            this._Value = value;
        }
        internal ComponentID(string value) : this(new Guid(value)) { }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override bool Equals(object o)
        {
            ComponentID componentID = (ComponentID)o;
            return this.Value == componentID.Value ? true : false;
        }
    }
}
