﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Projects
{
    public class ComponentDictionaryImpl : ComponentDictionary
    {
        private Dictionary<string, List<Component>> _Dictionary;

        ///--------------------------------
        /// <summary>
        /// </summary>
        public ComponentDictionaryImpl()
        {
            _Dictionary = new Dictionary<string, List<Component>>();
        }

        public int Count
        {
            get { return _Dictionary.Count; }
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public List<Component>[] Values
        {
            get
            {
                List<List<Component>> valueList = new List<List<Component>>();
                foreach (List<Component> value in _Dictionary.Values)
                {
                    valueList.Add(value);
                }

                return valueList.ToArray();
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string[] Names
        {
            get { return _Dictionary.Keys.ToArray(); }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public override string[] DuplicatedNames
        {
            get
            {
                List<Component> componentList = null;
                List<string> names = new List<string>();

                foreach (string key in _Dictionary.Keys)
                {
                    if (_Dictionary.TryGetValue(key, out componentList) == true)
                    {
                        if (componentList.Count > 1)
                        {
                            names.Add(key);
                        }
                    }
                }

                return names.ToArray();
            }
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public override Component[] this[string name]
        {
            get
            {
                List<Component> components = new List<Component>();

                _Dictionary.TryGetValue(name, out components);

                return components.ToArray();
            }
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public override bool Contains(string name)
        {
            return _Dictionary.ContainsKey(name);
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public void Add(string name, Component component)
        {
            List<Component> componentList = null;

            if (_Dictionary.TryGetValue(name, out componentList) == false)
            {
                componentList = new List<Component>();
                _Dictionary.Add(name, componentList);
            }
            componentList.Add(component);
        }

        ///--------------------------------
        /// <summary>
        /// 不要？
        /// </summary>
        public void Remove(string name)
        {
            List<Component> componentList = null;

            if (_Dictionary.TryGetValue(name, out componentList) == true)
            {
                List<Component> notRemoveComponentList = new List<Component>();

                foreach (Component component in componentList)
                {
                    if (name != component.Name)
                    {
                        notRemoveComponentList.Add(component);
                    }
                }

                _Dictionary.Add(name, notRemoveComponentList);
            }
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public void Remove(Component component)
        {
            string name = component.Name;
            List<Component> componentList = null;

            if (_Dictionary.TryGetValue(name, out componentList) == true)
            {

                componentList.Remove(component);

                if (0 == componentList.Count)
                {
                    _Dictionary.Remove(name);
                }

            }
        }

        ///--------------------------------
        /// <summary>
        /// </summary>
        public void Rename(string oldName, string newName)
        {
            List<Component> componentList = null;

            if (_Dictionary.TryGetValue(oldName, out componentList) == true)
            {
                List<Component> oldComponentList = new List<Component>();
                List<Component> newComponentList = new List<Component>();

                foreach (Component component in componentList)
                {
                    if (oldName == component.Name)
                    {
                        oldComponentList.Add(component);
                    }
                    else
                    {
                        if (newName == component.Name)
                        {
                            newComponentList.Add(component);
                        }
                        else
                        {
                            Debug.Assert(false, "Impossible component name");
                        }
                    }
                }

                _Dictionary.Remove(oldName);

                List<Component> tempComponentList = null;

                if (oldComponentList.Count > 0)
                {
                    if (_Dictionary.TryGetValue(oldName, out tempComponentList) != false)
                    {
                        tempComponentList.AddRange(oldComponentList);
                    }
                    else
                    {
                        _Dictionary.Add(oldName, oldComponentList);
                    }
                }

                if (newComponentList.Count > 0)
                {
                    if (_Dictionary.TryGetValue(newName, out tempComponentList) != false)
                    {
                        tempComponentList.AddRange(newComponentList);
                    }
                    else
                    {
                        _Dictionary.Add(newName, newComponentList);
                    }
                }
            }
        }
    }
}
