﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using System;
    using NintendoWare.ToolDevelopmentKit;

    public class BankServiceReference : IDisposable
    {
        private bool isClosed = false;

        public BankServiceReference(BankService target)
        {
            Ensure.Argument.NotNull(target);
            this.Target = target;
        }

        ~BankServiceReference()
        {
            this.Close();
        }

        public event EventHandler Closed;

        public BankService Target { get; private set; }

        public bool IsClosed
        {
            get { return this.isClosed; }
        }

        public void Close()
        {
            if (this.isClosed)
            {
                return;
            }

            this.isClosed = true;
            this.OnClosed(EventArgs.Empty);
        }

        void IDisposable.Dispose()
        {
            this.Close();
        }

        protected virtual void OnClosed(EventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.Closed != null)
            {
                this.Closed(this, e);
            }
        }
    }
}
