﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Logs
{
    /// <summary>
    /// 出力レベルを表します。
    /// </summary>
    public enum OutputLevel
    {
        Level0 = 0,
        Level1 = 1,
        Level2 = 2,
        Level3 = 3,

        /// <summary>
        /// エラーであることを表します。
        /// </summary>
        Error = Level0,

        /// <summary>
        /// 警告であることを表します。
        /// </summary>
        Warning = Level1,

        /// <summary>
        /// 情報であることを表します。
        /// </summary>
        Information = Level2,

        /// <summary>
        /// 詳細情報であることを表します。
        /// </summary>
        Detail = Level3,
    }
}
