﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Logs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using ToolDevelopmentKit;

    public class Logger : ILogger
    {
        private LinkedList<OutputLine> lines = new LinkedList<OutputLine>();
        private HashSet<OutputLevel> lineLevels = new HashSet<OutputLevel>();

        public event EventHandler<OutputLineEventArgs> LineAdded;

        public IEnumerable<OutputLine> Lines
        {
            get { return this.lines; }
        }

        public bool HasLineLevel(OutputLevel level)
        {
            return this.lineLevels.Contains(level);
        }

        public bool HasLines(LineFilterHandler lineFilter)
        {
            Ensure.Argument.NotNull(lineFilter);
            return this.GetLines(lineFilter).FirstOrDefault() != null;
        }

        public IEnumerable<OutputLine> GetLines(LineFilterHandler lineFilter)
        {
            Ensure.Argument.NotNull(lineFilter);
            return from OutputLine line in this.lines
                   where lineFilter(line)
                   select line;
        }

        public void AddLine(OutputLine line)
        {
            Ensure.Argument.NotNull(line);

            this.lines.AddLast(line);

            if (!this.lineLevels.Contains(line.Level))
            {
                this.lineLevels.Add(line.Level);
            }

            this.OnAddLine(new OutputLineEventArgs(line));
        }

        protected virtual void OnAddLine(OutputLineEventArgs e)
        {
            Assertion.Argument.NotNull(e);

            if (this.LineAdded != null)
            {
                this.LineAdded(this, e);
            }
        }
    }
}
