﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    public class XmlListColumnOutput
    {
        public XmlListColumnOutput()
        {
            this.IsOutput = true;
        }

        [XmlAttribute("Name")]
        public string Name { get; set; }

        [XmlAttribute("IsOutput")]
        public bool IsOutput { get; set; }

        /// <summary>
        /// IsOutput属性を定義するかどうかを取得します。
        /// </summary>
        [XmlIgnore]
        public virtual bool IsOutputSpecified
        {
            get { return !IsOutput; }
        }
    }
}
