﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using System.Xml.Serialization;

    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment0,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment0TextParam : XmlStringParam
    {
        /// <summary>
        /// Name属性は定義しません。
        /// </summary>
        [XmlIgnore]
        public override bool NameSpecified
        {
            get { return false; }
        }

        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment0;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment1,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment1TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment1;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment2,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment2TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment2;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment3,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment3TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment3;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment4,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment4TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment4;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment5,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment5TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment5;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment6,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment6TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment6;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment7,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment7TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment7;
        }
    }

    ///
    [Serializable]
    [XmlRoot(
        XmlParameterNames.ColorComment.Comment8,
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class XmlColorComment8TextParam : XmlColorComment0TextParam
    {
        /// <summary>
        /// 名前を検証し有効化します。
        /// </summary>
        /// <param name="name">名前を指定します。</param>
        /// <returns>有効化された名前を返します。</returns>
        protected override string ValidateName(string name)
        {
            return XmlParameterNames.ColorComment.Comment8;
        }
    }
}
