﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Diagnostics;

    public static class XmlInstrumentNoteOffModeEx
    {
        public static string ToText(this XmlInstrumentNoteOffMode value)
        {
            switch (value)
            {
                case XmlInstrumentNoteOffMode.Release:
                    return "Release";

                case XmlInstrumentNoteOffMode.Ignore:
                    return "Ignore";
            }

            Debug.Assert(false, "An unexpected value");
            return String.Empty;
        }

        public static XmlInstrumentNoteOffMode Parse(string text)
        {
            if (null == text) { throw new ArgumentNullException("text"); }

            switch (text)
            {
                case "Release":
                    return XmlInstrumentNoteOffMode.Release;

                case "Ignore":
                    return XmlInstrumentNoteOffMode.Ignore;
            }

            throw new ArgumentException("invalid text.");
        }
    }
}
