﻿using NintendoWare.ToolDevelopmentKit;
using System.Linq;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    public static class XmlParameterAccessor
    {
        public static bool FindParameterValue<TValue>(this IXmlParameterProvider target, string parameterName, out TValue value)
        {
            Ensure.Argument.NotNull(target);

            var parameter = target.Parameters.FirstOrDefault(param => param.Name == parameterName);

            if (parameter != null && parameter.XmlValue is TValue)
            {
                value = (TValue)parameter.XmlValue;
                return true;
            }
            else
            {
                value = default(TValue);
                return false;
            }
        }
    }
}
