﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;
    using ToolDevelopmentKit.Conversion;

    public class SoundSetModel2XmlTranslator : Model2XmlTranslator
    {
        public SoundSetModel2XmlTranslator(SoundSetItemParamTranslator translator)
            : base(translator)
        {
        }

        public SoundSetModel2XmlTranslator()
            : base(new SoundSetItemParamTranslator())
        {
            this.AddConverter<SoundSet, XmlSoundSet>(this.ComponentToXmlComponentWithoutName<SoundSet, XmlSoundSet>);
            this.AddConverter<StreamSoundPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveSoundSetPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundSetPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SequenceSoundPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<SoundSetBankPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<PlayerPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<WaveArchivePack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<GroupPack, XmlSoundSetItemFolder>(this.SoundSetItemPackToXmlSoundSetItemFolder);
            this.AddConverter<StreamSoundBase, XmlStreamSound>();
            this.AddConverter<StreamSoundTrackBase, XmlStreamSoundTrack>();
            this.AddConverter<WaveSoundSetBase, XmlWaveSoundSet>();
            this.AddConverter<WaveSoundBase, XmlWaveSound>();
            this.AddConverter<SequenceSoundSetBase, XmlSequenceSoundSet>();
            this.AddConverter<SequenceSoundBase, XmlSequenceSound>();
            this.AddConverter<SoundSetBankBase, XmlSoundSetBank>();
            this.AddConverter<PlayerBase, XmlPlayer>();
            this.AddConverter<WaveArchiveBase, XmlWaveArchive>();
            this.AddConverter<GroupBase, XmlGroup>();
            this.AddConverter<GroupItemBase, XmlGroupItem>();
        }

        public XmlSoundSet Run(SoundSet soundSet)
        {
            return this.Run<XmlSoundSet>(soundSet) as XmlSoundSet;
        }

        /// <summary>
        /// SoundSetItemPack から XmlSoundSetItemFolder に変換します。
        /// </summary>
        /// <param name="src">変換元のオブジェクトを指定します。</param>
        /// <param name="dstType">変換後の型を指定します。</param>
        /// <param name="converter">変換の状態です。Converterから渡されます。</param>
        /// <returns>変換後のオブジェクトを返します。</returns>
        private object SoundSetItemPackToXmlSoundSetItemFolder(object src, Type dstType, Converter converter)
        {
            Assertion.Argument.True(src is SoundSetItemPack);
            Assertion.Argument.True(dstType == typeof(XmlSoundSetItemFolder));

            SoundSetItemPack srcItem = src as SoundSetItemPack;
            XmlSoundSetItemFolder dest = new XmlSoundSetItemFolder()
            {
                Name = srcItem.Name,
            };

            TranslateParameters(srcItem, dest, converter);
            TranslateChildren(srcItem, dest, converter);

            return dest;
        }
    }
}
