﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Documents
{
    /// <summary>
    /// ドキュメントへの参照を表します。
    /// </summary>
    public class DocumentReference : IDisposable, ICloneable
    {
        private bool _disposed = false;

        private DocumentManager _DocumentManager = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="documentManager">ドキュメントマネージャ。</param>
        public DocumentReference(DocumentManager documentManager)
        {
            _DocumentManager = documentManager;
        }

        ~DocumentReference()
        {
            Dispose(false);
        }

        /// <summary>
        /// ドキュメントを取得または設定します。
        /// </summary>
        public Document Document { get; set; }

        /// <summary>
        /// ドキュメント参照を破棄します。
        /// </summary>
        public void Dispose()
        {
            Dispose(true);

            // This object will be cleaned up by the Dispose method.
            // Therefore, you should call GC.SupressFinalize to
            // take this object off the finalization queue
            // and prevent finalization code for this object
            // from executing a second time.
            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// ドキュメント参照を閉じます。
        /// </summary>
        public void Close()
        {
            if (null == _DocumentManager) { return; }

            _DocumentManager.Remove(this);
            _DocumentManager = null;
            this.Document = null;
        }

        /// <summary>
        /// ドキュメント参照のクローンを作成します。
        /// </summary>
        /// <returns></returns>
        public DocumentReference Clone()
        {
            DocumentReference clone;

            clone = this._DocumentManager.Add(this.Document);

            return clone;
        }

        object System.ICloneable.Clone()
        {
            return this.Clone();
        }

        private void Dispose(bool disposing)
        {
            if (_disposed) { return; }

            Close();

            _disposed = true;
        }
    }
}
