﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Core.Resources;
using System;

namespace NintendoWare.SoundFoundation.Documents
{
    /// <summary>
    /// ドキュメントを開こうとするときに発生するイベントの引数です。
    /// </summary>
    public class DocumentOpeningEventArgs : EventArgs
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="resource">リソースを指定します。</param>
        public DocumentOpeningEventArgs(IStreamResource resource)
        {
            this.Resource = resource;
            this.FilePath = (resource as FileResource)?.FilePath;
        }

        /// <summary>
        /// リソースを取得します。
        /// </summary>
        public IStreamResource Resource { get; }

        /// <summary>
        /// ファイルパスを取得します。
        /// <para>
        /// <see cref="Resource"/> がファイルでない場合は null です。
        /// </para>
        /// </summary>
        public string FilePath { get; }
    }
}
