﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Core
{
    public class TreeTracer
    {
        private char _separator;

        public TreeTracer(char separator)
        {
            _separator = '/';
        }

        public char Separator
        {
            get { return _separator; }
        }

        public string GetFullPath(INamedTreeObject targetObject)
        {
            string path;

            List<string> pathList = createPathList(targetObject);
            path = pathListToPath(pathList);

            return path;
        }

        public string GetPath(INamedTreeObject targetObject, INamedTreeObject baseObject)
        {
            string path;
            List<string> targetPathList = createPathList(targetObject);
            List<string> basePathList = createPathList(baseObject);

            if (targetPathList.Count == 0 || basePathList.Count == 0)
            {
                path = string.Empty;
            }
            else
            {
                string targetPath = pathListToPath(targetPathList);
                string basePath = pathListToPath(basePathList);
                if (targetPath == basePath)
                {
                    path = targetPath;
                }
                else
                {
                    int minCount = (targetPathList.Count < basePathList.Count ?
                                    targetPathList.Count : basePathList.Count);
                    int otherIndex = -1;
                    bool baseIsParent = false;
                    int i;
                    for (i = 0; i < minCount; i++)
                    {
                        if (targetPathList[i] == basePathList[i])
                        {
                            otherIndex = i;
                        }
                        if (targetPathList[i] != basePathList[i])
                        {
                            break;
                        }
                    }
                    baseIsParent = (i == minCount && minCount == basePathList.Count);
                    if (otherIndex < 0)
                    {
                        path = string.Empty;
                    }
                    else
                    {
                        List<string> otherTargetPathList = new List<string>();
                        for (i = otherIndex + 1; i < targetPathList.Count; i++)
                        {
                            otherTargetPathList.Add(targetPathList[i]);
                        }
                        string otherTargetPath = pathListToPath(otherTargetPathList);

                        string otherBasePath = string.Empty;
                        if (baseIsParent != true)
                        {
                            for (i = otherIndex; i < basePathList.Count; i++)
                            {
                                otherBasePath += ".." + this.Separator;
                            }
                        }

                        path = otherBasePath + otherTargetPath;
                    }
                }
            }

            return path;
        }

        public INamedTreeObject Trace(INamedTreeObject treeObject, string path)
        {
            if (0 == path.Length)
            {
                return null;
            }

            INamedTreeObject currentObject = treeObject;
            string relativePath = path;

            if (path[0] == '/')
            {
                while (currentObject.Parent != null)
                {
                    currentObject = currentObject.Parent as INamedTreeObject;
                }

                relativePath = path.Substring(1);
            }

            List<string> targetPathList = createPathListByPath(relativePath);

            bool emptyNameFound = false;

            foreach (string name in targetPathList)
            {

                if (emptyNameFound)
                {
                    return null;
                }

                if (0 == name.Length)
                {
                    emptyNameFound = true;
                    continue;
                }

                if (name == "..")
                {
                    currentObject = (INamedTreeObject)(currentObject.Parent);
                    continue;
                }
                if (name == ".")
                {
                    continue;
                }

                ITreeObjectCollection children = currentObject.Children;
                bool find = false;
                foreach (ITreeObject child in children)
                {
                    if (name == ((INamedTreeObject)child).Name)
                    {
                        find = true;
                        currentObject = (INamedTreeObject)child;
                        break;
                    }
                }
                if (find == false)
                {
                    currentObject = null;
                    break;
                }
            }

            return currentObject;
        }

        private List<string> createPathList(INamedTreeObject namedTreeObject)
        {
            List<string> pathList;

            if (namedTreeObject == null)
            {
                pathList = new List<string>();
            }
            else
            {
                pathList = createPathList((INamedTreeObject)(namedTreeObject.Parent));
                pathList.Add(namedTreeObject.Name);
            }

            return pathList;
        }

        private List<string> createPathListByPath(string path)
        {
            List<string> pathList = new List<string>();

            string[] nameList = path.Split(new Char[] { this.Separator });

            foreach (string name in nameList)
            {
                pathList.Add(name);
            }

            return pathList;
        }

        private string pathListToPath(List<string> pathList)
        {
            string path = string.Empty;

            if (pathList.Count > 0)
            {
                path += pathList[0];
            }
            for (int i = 1; i < pathList.Count; i++)
            {
                path += this.Separator;
                path += pathList[i];
            }

            return path;
        }
    }
}
