﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Collections.Specialized;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// ツリーオブジェクトのコレクションです。
    /// </summary>
    public interface ITreeObjectCollection : INotifyCollectionChanged, ICollection<ITreeObject>
    {
        /// <summary>
        /// 指定インデックスのアイテムを取得します。
        /// </summary>
        /// <param name="index">アイテムのインデックス。</param>
        /// <returns>アイテム。</returns>
        ITreeObject this[int index] { get; }

        /// <summary>
        /// 指定アイテムのインデックスを取得します。
        /// </summary>
        /// <param name="item">アイテム。</param>
        /// <returns>アイテムのインデックス。</returns>
        int IndexOf(ITreeObject item);

        /// <summary>
        /// アイテムを挿入します。
        /// </summary>
        /// <param name="index">挿入先のインデックス。</param>
        /// <param name="item">挿入するアイテム。</param>
        void Insert(int index, ITreeObject item);

        /// <summary>
        /// 指定インデックスのアイテムを削除します。
        /// </summary>
        /// <param name="index">削除するアイテムのインデックス。</param>
        void RemoveAt(int index);
    }
}
