﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using NintendoWare.SoundFoundation.Core.Collections;
using System.Collections.Generic;

namespace NintendoWare.SoundFoundation.Core
{
    /// <summary>
    /// ルーティングイベント機能を提供します。
    /// </summary>
    public interface IEventRoutable
    {
        /// <summary>
        /// イベントツリー上の親を取得します。
        /// </summary>
        IEventRoutable Parent { get; }

        /// <summary>
        /// イベントツリー上の子コレクションを取得します。
        /// </summary>
        IReadOnlyEventRoutableCollection Children { get; }

        /// <summary>
        /// このオブジェクトに関連付けられたルータを取得します。
        /// </summary>
        EventRouter Router { get; }
    }
}
