﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Core
{
    using System;
    using MessageResource = NintendoWare.SoundFoundation.Resources.MessageResource;

    /// <summary>
    /// サポートされていないファイルを示す例外クラスです。
    /// </summary>
    public class FileNotSupportedException : Exception
    {
        private string filePath;

        public FileNotSupportedException()
            : this(string.Empty, string.Empty)
        {
        }

        public FileNotSupportedException(string filePath)
            : this(MessageResource.Message_UnsupportedFileFormatWithoutStringFormat, filePath)
        {
        }

        public FileNotSupportedException(string message, string filePath)
            : base(message)
        {
            if (null == filePath) { throw new ArgumentNullException("filePath"); }
            this.filePath = filePath;
        }

        /// <summary>
        /// 対象ファイルパスを取得します。
        /// </summary>
        public string FilePath
        {
            get { return this.filePath; }
        }
    }
}
