﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Core.Win32
{
    public class WindowsHookEventArgs : EventArgs
    {
        private int _code;
        private IntPtr _wParam;
        private IntPtr _lParam;
        private bool _sendKeyMessage = true;

        public WindowsHookEventArgs(int code, IntPtr wParam, IntPtr lParam)
        {
            _code = code;
            _wParam = wParam;
            _lParam = lParam;
        }

        public int Code
        {
            get { return _code; }
        }

        public IntPtr WParam
        {
            get { return _wParam; }
        }

        public IntPtr LParam
        {
            get { return _lParam; }
        }

        public bool SendKeyMessage
        {
            get { return _sendKeyMessage; }
            set { _sendKeyMessage = value; }
        }
    }

    public delegate void WindowsHookEventHandler(object sender, WindowsHookEventArgs e);
}
