﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace NintendoWare.SoundFoundation.Core.Win32
{
    public class WindowsHook
    {
        private readonly User32.HookProc _hookProc;

        private IntPtr _hHook = IntPtr.Zero;

        public WindowsHook()
        {
            _hookProc = HookProc;
        }

        public event WindowsHookEventHandler Hook;

        public bool SetHook(int hookID)
        {
            if (IntPtr.Zero != _hHook) { return false; }

            _hHook = User32.SetWindowsHookEx(hookID, _hookProc, IntPtr.Zero,
                                              Kernel32.GetCurrentThreadId());
            return (null != _hHook);
        }

        public bool Unhook()
        {
            if (IntPtr.Zero == _hHook) { return true; }

            bool result = User32.UnhookWindowsHookEx(_hHook);

            if (result)
            {
                _hHook = IntPtr.Zero;
            }

            return result;
        }

        protected virtual void OnHook(WindowsHookEventArgs e)
        {
            if (null != Hook)
            {
                Hook(this, e);
            }
        }

        private int CallNext(int nCode, IntPtr wParam, IntPtr lParam)
        {
            return User32.CallNextHookEx(_hHook, nCode, wParam, lParam);
        }

        private int HookProc(int code, IntPtr wParam, IntPtr lParam)
        {
            if (0 > code) { return CallNext(code, wParam, lParam); }

            WindowsHookEventArgs e = new WindowsHookEventArgs(code, wParam, lParam);
            OnHook(e);

            CallNext(code, wParam, lParam);

            return e.SendKeyMessage ? 0 : 1;
        }
    }
}
