﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Runtime.InteropServices;

namespace NintendoWare.SoundFoundation.Core.Win32
{
    //---------------------------------------------------------------------
    // WinUser.h
    //---------------------------------------------------------------------
    #region CS
    /// <summary>
    /// クラススタイル。
    /// </summary>
    public static class CS
    {
        /// <summary></summary>
        public const int CS_VREDRAW = 0x0001;
        /// <summary></summary>
        public const int CS_HREDRAW = 0x0002;
        /// <summary></summary>
        public const int CS_DBLCLKS = 0x0008;
        /// <summary></summary>
        public const int CS_OWNDC = 0x0020;
        /// <summary></summary>
        public const int CS_CLASSDC = 0x0040;
        /// <summary></summary>
        public const int CS_PARENTDC = 0x0080;
        /// <summary></summary>
        public const int CS_NOCLOSE = 0x0200;
        /// <summary></summary>
        public const int CS_SAVEBITS = 0x0800;
        /// <summary></summary>
        public const int CS_BYTEALIGNCLIENT = 0x1000;
        /// <summary></summary>
        public const int CS_BYTEALIGNWINDOW = 0x2000;
        /// <summary></summary>
        public const int CS_GLOBALCLASS = 0x4000;
        /// <summary></summary>
        public const int CS_IME = 0x00010000;
        /// <summary></summary>
        public const int CS_DROPSHADOW = 0x00020000;
    }
    #endregion

    #region DCX
    /// <summary>
    /// デバイスコンテキストの作成方法。
    /// </summary>
    public static class DCX
    {
        /// <summary></summary>
        public const uint DCX_WINDOW = 0x00000001;
        /// <summary></summary>
        public const uint DCX_CACHE = 0x00000002;
        /// <summary></summary>
        public const uint DCX_NORESETATTRS = 0x00000004;
        /// <summary></summary>
        public const uint DCX_CLIPCHILDREN = 0x00000008;
        /// <summary></summary>
        public const uint DCX_CLIPSIBLINGS = 0x00000010;
        /// <summary></summary>
        public const uint DCX_PARENTCLIP = 0x00000020;
        /// <summary></summary>
        public const uint DCX_EXCLUDERGN = 0x00000040;
        /// <summary></summary>
        public const uint DCX_INTERSECTRGN = 0x00000080;
        /// <summary></summary>
        public const uint DCX_EXCLUDEUPDATE = 0x00000100;
        /// <summary></summary>
        public const uint DCX_INTERSECTUPDATE = 0x00000200;
        /// <summary></summary>
        public const uint DCX_LOCKWINDOWUPDATE = 0x00000400;
        /// <summary></summary>
        public const uint DCX_VALIDATE = 0x00200000;
    }
    #endregion

    #region WS
    /// <summary>
    /// ウィンドウスタイル。
    /// </summary>
    public static class WS
    {
        /// <summary></summary>
        public const int WS_OVERLAPPED = 0x00000000;
        /// <summary></summary>
        public const int WS_POPUP = unchecked((int)0x80000000);
        /// <summary></summary>
        public const int WS_CHILD = 0x40000000;
        /// <summary></summary>
        public const int WS_MINIMIZE = 0x20000000;
        /// <summary></summary>
        public const int WS_VISIBLE = 0x10000000;
        /// <summary></summary>
        public const int WS_DISABLED = 0x08000000;
        /// <summary></summary>
        public const int WS_CLIPSIBLINGS = 0x04000000;
        /// <summary></summary>
        public const int WS_CLIPCHILDREN = 0x02000000;
        /// <summary></summary>
        public const int WS_MAXIMIZE = 0x01000000;
        /// <summary></summary>
        public const int WS_CAPTION = 0x00C00000; // WS_BORDER | WS_DLGFRAME
        /// <summary></summary>
        public const int WS_BORDER = 0x00800000;
        /// <summary></summary>
        public const int WS_DLGFRAME = 0x00400000;
        /// <summary></summary>
        public const int WS_VSCROLL = 0x00200000;
        /// <summary></summary>
        public const int WS_HSCROLL = 0x00100000;
        /// <summary></summary>
        public const int WS_SYSMENU = 0x00080000;
        /// <summary></summary>
        public const int WS_THICKFRAME = 0x00040000;
        /// <summary></summary>
        public const int WS_GROUP = 0x00020000;
        /// <summary></summary>
        public const int WS_TABSTOP = 0x00010000;
        /// <summary></summary>
        public const int WS_MINIMIZEBOX = 0x00020000;
        /// <summary></summary>
        public const int WS_MAXIMIZEBOX = 0x00010000;
        /// <summary></summary>
        public const int WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);
        /// <summary></summary>
        public const int WS_POPUPWINDOW = (WS_POPUP | WS_BORDER | WS_SYSMENU);
        /// <summary></summary>
        public const int WS_CHILDWINDOW = (WS_CHILD);
        /// <summary></summary>
        public const int WS_TILED = WS_OVERLAPPED;
        /// <summary></summary>
        public const int WS_ICONIC = WS_MINIMIZE;
        /// <summary></summary>
        public const int WS_SIZEBOX = WS_THICKFRAME;
        /// <summary></summary>
        public const int WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;
    }
    #endregion

    #region WS_EX
    /// <summary>
    /// 拡張ウィンドウスタイル。
    /// </summary>
    public static class WS_EX
    {
        /// <summary></summary>
        public const int WS_EX_DLGMODALFRAME = 0x00000001;
        /// <summary></summary>
        public const int WS_EX_NOPARENTNOTIFY = 0x00000004;
        /// <summary></summary>
        public const int WS_EX_TOPMOST = 0x00000008;
        /// <summary></summary>
        public const int WS_EX_ACCEPTFILES = 0x00000010;
        /// <summary></summary>
        public const int WS_EX_TRANSPARENT = 0x00000020;
        /// <summary></summary>
        public const int WS_EX_MDICHILD = 0x00000040;
        /// <summary></summary>
        public const int WS_EX_TOOLWINDOW = 0x00000080;
        /// <summary></summary>
        public const int WS_EX_WINDOWEDGE = 0x00000100;
        /// <summary></summary>
        public const int WS_EX_CLIENTEDGE = 0x00000200;
        /// <summary></summary>
        public const int WS_EX_CONTEXTHELP = 0x00000400;
        /// <summary></summary>
        public const int WS_EX_RIGHT = 0x00001000;
        /// <summary></summary>
        public const int WS_EX_LEFT = 0x00000000;
        /// <summary></summary>
        public const int WS_EX_RTLREADING = 0x00002000;
        /// <summary></summary>
        public const int WS_EX_LTRREADING = 0x00000000;
        /// <summary></summary>
        public const int WS_EX_LEFTSCROLLBAR = 0x00004000;
        /// <summary></summary>
        public const int WS_EX_RIGHTSCROLLBAR = 0x00000000;
        /// <summary></summary>
        public const int WS_EX_CONTROLPARENT = 0x00010000;
        /// <summary></summary>
        public const int WS_EX_STATICEDGE = 0x00020000;
        /// <summary></summary>
        public const int WS_EX_APPWINDOW = 0x00040000;
        /// <summary></summary>
        public const int WS_EX_OVERLAPPEDWINDOW = (WS_EX_WINDOWEDGE | WS_EX_CLIENTEDGE);
        /// <summary></summary>
        public const int WS_EX_PALETTEWINDOW = (WS_EX_WINDOWEDGE | WS_EX_TOOLWINDOW | WS_EX_TOPMOST);
        /// <summary></summary>
        public const int WS_EX_LAYERED = 0x00080000;
        /// <summary></summary>
        public const int WS_EX_NOINHERITLAYOUT = 0x00100000; // Disable inheritence of mirroring by children
        /// <summary></summary>
        public const int WS_EX_LAYOUTRTL = 0x00400000; // Right to left mirroring
        /// <summary></summary>
        public const int WS_EX_COMPOSITED = 0x02000000;
        /// <summary></summary>
        public const int WS_EX_NOACTIVATE = 0x08000000;
    }
    #endregion

    #region WPF
    /// <summary>
    /// ウィンドウ配置情報フラグ。
    /// </summary>
    public static class WPF
    {
        /// <summary></summary>
        public const int WPF_SETMINPOSITION = 0x0001;
        /// <summary></summary>
        public const int WPF_RESTORETOMAXIMIZED = 0x0002;
        /// <summary></summary>
        public const int WPF_ASYNCWINDOWPLACEMENT = 0x0004;
    }
    #endregion

    #region SW
    /// <summary>
    /// ウィンドウ表示フラグ。
    /// </summary>
    public static class SW
    {
        /// <summary></summary>
        public const int SW_HIDE = 0;
        /// <summary></summary>
        public const int SW_SHOWNORMAL = 1;
        /// <summary></summary>
        public const int SW_NORMAL = 1;
        /// <summary></summary>
        public const int SW_SHOWMINIMIZED = 2;
        /// <summary></summary>
        public const int SW_SHOWMAXIMIZED = 3;
        /// <summary></summary>
        public const int SW_MAXIMIZE = 3;
        /// <summary></summary>
        public const int SW_SHOWNOACTIVATE = 4;
        /// <summary></summary>
        public const int SW_SHOW = 5;
        /// <summary></summary>
        public const int SW_MINIMIZE = 6;
        /// <summary></summary>
        public const int SW_SHOWMINNOACTIVE = 7;
        /// <summary></summary>
        public const int SW_SHOWNA = 8;
        /// <summary></summary>
        public const int SW_RESTORE = 9;
        /// <summary></summary>
        public const int SW_SHOWDEFAULT = 10;
        /// <summary></summary>
        public const int SW_FORCEMINIMIZE = 11;
        /// <summary></summary>
        public const int SW_MAX = 11;
    }
    #endregion

    #region SWP
    /// <summary>
    /// ウィンドウ位置フラグ。
    /// </summary>
    public static class SWP
    {
        /// <summary></summary>
        public const int SWP_NOSIZE = 0x0001;
        /// <summary></summary>
        public const int SWP_NOMOVE = 0x0002;
        /// <summary></summary>
        public const int SWP_NOZORDER = 0x0004;
        /// <summary></summary>
        public const int SWP_NOREDRAW = 0x0008;
        /// <summary></summary>
        public const int SWP_NOACTIVATE = 0x0010;
        /// <summary></summary>
        public const int SWP_FRAMECHANGED = 0x0020;  /* The frame changed: send WM_NCCALCSIZE */
        /// <summary></summary>
        public const int SWP_SHOWWINDOW = 0x0040;
        /// <summary></summary>
        public const int SWP_HIDEWINDOW = 0x0080;
        /// <summary></summary>
        public const int SWP_NOCOPYBITS = 0x0100;
        /// <summary></summary>
        public const int SWP_NOOWNERZORDER = 0x0200;  /* Don't do owner Z ordering */
        /// <summary></summary>
        public const int SWP_NOSENDCHANGING = 0x0400;  /* Don't send WM_WINDOWPOSCHANGING */
        /// <summary></summary>
        public const int SWP_DRAWFRAME = SWP_FRAMECHANGED;
        /// <summary></summary>
        public const int SWP_NOREPOSITION = SWP_NOOWNERZORDER;
        /// <summary></summary>
        public const int SWP_DEFERERASE = 0x2000;
        /// <summary></summary>
        public const int SWP_ASYNCWINDOWPOS = 0x4000;
    }
    #endregion

    #region WM
    /// <summary>
    /// ウィンドウメッセージ。
    /// </summary>
    public static class WM
    {
        /// <summary></summary>
        public const int WM_NULL = 0x0000;
        /// <summary></summary>
        public const int WM_CREATE = 0x0001;
        /// <summary></summary>
        public const int WM_DESTROY = 0x0002;
        /// <summary></summary>
        public const int WM_MOVE = 0x0003;
        /// <summary></summary>
        public const int WM_SIZE = 0x0005;
        /// <summary></summary>
        public const int WM_ACTIVATE = 0x0006;
        /// <summary></summary>
        public const int WM_SETFOCUS = 0x0007;
        /// <summary></summary>
        public const int WM_KILLFOCUS = 0x0008;
        /// <summary></summary>
        public const int WM_ENABLE = 0x000A;
        /// <summary></summary>
        public const int WM_SETREDRAW = 0x000B;
        /// <summary></summary>
        public const int WM_SETTEXT = 0x000C;
        /// <summary></summary>
        public const int WM_GETTEXT = 0x000D;
        /// <summary></summary>
        public const int WM_GETTEXTLENGTH = 0x000E;
        /// <summary></summary>
        public const int WM_PAINT = 0x000F;
        /// <summary></summary>
        public const int WM_CLOSE = 0x0010;
        /// <summary></summary>
        public const int WM_QUERYENDSESSION = 0x0011;
        /// <summary></summary>
        public const int WM_QUERYOPEN = 0x0013;
        /// <summary></summary>
        public const int WM_ENDSESSION = 0x0016;
        /// <summary></summary>
        public const int WM_QUIT = 0x0012;
        /// <summary></summary>
        public const int WM_ERASEBKGND = 0x0014;
        /// <summary></summary>
        public const int WM_SYSCOLORCHANGE = 0x0015;
        /// <summary></summary>
        public const int WM_SHOWWINDOW = 0x0018;
        /// <summary></summary>
        public const int WM_CTLCOLOR = 0x0019; // WindowsX.h で定義
        /// <summary></summary>
        public const int WM_WININICHANGE = 0x001A;
        /// <summary></summary>
        public const int WM_SETTINGCHANGE = WM_WININICHANGE;
        /// <summary></summary>
        public const int WM_DEVMODECHANGE = 0x001B;
        /// <summary></summary>
        public const int WM_ACTIVATEAPP = 0x001C;
        /// <summary></summary>
        public const int WM_FONTCHANGE = 0x001D;
        /// <summary></summary>
        public const int WM_TIMECHANGE = 0x001E;
        /// <summary></summary>
        public const int WM_CANCELMODE = 0x001F;
        /// <summary></summary>
        public const int WM_SETCURSOR = 0x0020;
        /// <summary></summary>
        public const int WM_MOUSEACTIVATE = 0x0021;
        /// <summary></summary>
        public const int WM_CHILDACTIVATE = 0x0022;
        /// <summary></summary>
        public const int WM_QUEUESYNC = 0x0023;
        /// <summary></summary>
        public const int WM_GETMINMAXINFO = 0x0024;
        /// <summary></summary>
        public const int WM_PAINTICON = 0x0026;
        /// <summary></summary>
        public const int WM_ICONERASEBKGND = 0x0027;
        /// <summary></summary>
        public const int WM_NEXTDLGCTL = 0x0028;
        /// <summary></summary>
        public const int WM_SPOOLERSTATUS = 0x002A;
        /// <summary></summary>
        public const int WM_DRAWITEM = 0x002B;
        /// <summary></summary>
        public const int WM_MEASUREITEM = 0x002C;
        /// <summary></summary>
        public const int WM_DELETEITEM = 0x002D;
        /// <summary></summary>
        public const int WM_VKEYTOITEM = 0x002E;
        /// <summary></summary>
        public const int WM_CHARTOITEM = 0x002F;
        /// <summary></summary>
        public const int WM_SETFONT = 0x0030;
        /// <summary></summary>
        public const int WM_GETFONT = 0x0031;
        /// <summary></summary>
        public const int WM_SETHOTKEY = 0x0032;
        /// <summary></summary>
        public const int WM_GETHOTKEY = 0x0033;
        /// <summary></summary>
        public const int WM_QUERYDRAGICON = 0x0037;
        /// <summary></summary>
        public const int WM_COMPAREITEM = 0x0039;
        /// <summary></summary>
        public const int WM_GETOBJECT = 0x003D;
        /// <summary></summary>
        public const int WM_COMPACTING = 0x0041;
        /// <summary></summary>
        public const int WM_COMMNOTIFY = 0x0044; // no longer suported
        /// <summary></summary>
        public const int WM_WINDOWPOSCHANGING = 0x0046;
        /// <summary></summary>
        public const int WM_WINDOWPOSCHANGED = 0x0047;
        /// <summary></summary>
        public const int WM_POWER = 0x0048;
        /// <summary></summary>
        public const int WM_COPYDATA = 0x004A;
        /// <summary></summary>
        public const int WM_CANCELJOURNAL = 0x004B;
        /// <summary></summary>
        public const int WM_NOTIFY = 0x004E;
        /// <summary></summary>
        public const int WM_INPUTLANGCHANGEREQUEST = 0x0050;
        /// <summary></summary>
        public const int WM_INPUTLANGCHANGE = 0x0051;
        /// <summary></summary>
        public const int WM_TCARD = 0x0052;
        /// <summary></summary>
        public const int WM_HELP = 0x0053;
        /// <summary></summary>
        public const int WM_USERCHANGED = 0x0054;
        /// <summary></summary>
        public const int WM_NOTIFYFORMAT = 0x0055;
        /// <summary></summary>
        public const int WM_CONTEXTMENU = 0x007B;
        /// <summary></summary>
        public const int WM_STYLECHANGING = 0x007C;
        /// <summary></summary>
        public const int WM_STYLECHANGED = 0x007D;
        /// <summary></summary>
        public const int WM_DISPLAYCHANGE = 0x007E;
        /// <summary></summary>
        public const int WM_GETICON = 0x007F;
        /// <summary></summary>
        public const int WM_SETICON = 0x0080;
        /// <summary></summary>
        public const int WM_NCCREATE = 0x0081;
        /// <summary></summary>
        public const int WM_NCDESTROY = 0x0082;
        /// <summary></summary>
        public const int WM_NCCALCSIZE = 0x0083;
        /// <summary></summary>
        public const int WM_NCHITTEST = 0x0084;
        /// <summary></summary>
        public const int WM_NCPAINT = 0x0085;
        /// <summary></summary>
        public const int WM_NCACTIVATE = 0x0086;
        /// <summary></summary>
        public const int WM_GETDLGCODE = 0x0087;
        /// <summary></summary>
        public const int WM_SYNCPAINT = 0x0088;
        /// <summary></summary>
        public const int WM_NCMOUSEMOVE = 0x00A0;
        /// <summary></summary>
        public const int WM_NCLBUTTONDOWN = 0x00A1;
        /// <summary></summary>
        public const int WM_NCLBUTTONUP = 0x00A2;
        /// <summary></summary>
        public const int WM_NCLBUTTONDBLCLK = 0x00A3;
        /// <summary></summary>
        public const int WM_NCRBUTTONDOWN = 0x00A4;
        /// <summary></summary>
        public const int WM_NCRBUTTONUP = 0x00A5;
        /// <summary></summary>
        public const int WM_NCRBUTTONDBLCLK = 0x00A6;
        /// <summary></summary>
        public const int WM_NCMBUTTONDOWN = 0x00A7;
        /// <summary></summary>
        public const int WM_NCMBUTTONUP = 0x00A8;
        /// <summary></summary>
        public const int WM_NCMBUTTONDBLCLK = 0x00A9;
        /// <summary></summary>
        public const int WM_NCXBUTTONDOWN = 0x00AB;
        /// <summary></summary>
        public const int WM_NCXBUTTONUP = 0x00AC;
        /// <summary></summary>
        public const int WM_NCXBUTTONDBLCLK = 0x00AD;
        /// <summary></summary>
        public const int WM_INPUT = 0x00FF;
        /// <summary></summary>
        public const int WM_KEYFIRST = 0x0100;
        /// <summary></summary>
        public const int WM_KEYDOWN = 0x0100;
        /// <summary></summary>
        public const int WM_KEYUP = 0x0101;
        /// <summary></summary>
        public const int WM_CHAR = 0x0102;
        /// <summary></summary>
        public const int WM_DEADCHAR = 0x0103;
        /// <summary></summary>
        public const int WM_SYSKEYDOWN = 0x0104;
        /// <summary></summary>
        public const int WM_SYSKEYUP = 0x0105;
        /// <summary></summary>
        public const int WM_SYSCHAR = 0x0106;
        /// <summary></summary>
        public const int WM_SYSDEADCHAR = 0x0107;
        /// <summary></summary>
        public const int WM_UNICHAR = 0x0109;
        /// <summary></summary>
        public const int WM_KEYLAST_forXPLater = 0x0109; // _WIN32_WINNT >= 0x501
        /// <summary></summary>
        public const int WM_KEYLAST = 0x0108;
        /// <summary></summary>
        public const int WM_IME_STARTCOMPOSITION = 0x010D;
        /// <summary></summary>
        public const int WM_IME_ENDCOMPOSITION = 0x010E;
        /// <summary></summary>
        public const int WM_IME_COMPOSITION = 0x010F;
        /// <summary></summary>
        public const int WM_IME_KEYLAST = 0x010F;
        /// <summary></summary>
        public const int WM_INITDIALOG = 0x0110;
        /// <summary></summary>
        public const int WM_COMMAND = 0x0111;
        /// <summary></summary>
        public const int WM_SYSCOMMAND = 0x0112;
        /// <summary></summary>
        public const int WM_TIMER = 0x0113;
        /// <summary></summary>
        public const int WM_HSCROLL = 0x0114;
        /// <summary></summary>
        public const int WM_VSCROLL = 0x0115;
        /// <summary></summary>
        public const int WM_INITMENU = 0x0116;
        /// <summary></summary>
        public const int WM_INITMENUPOPUP = 0x0117;
        /// <summary></summary>
        public const int WM_MENUSELECT = 0x011F;
        /// <summary></summary>
        public const int WM_MENUCHAR = 0x0120;
        /// <summary></summary>
        public const int WM_ENTERIDLE = 0x0121;
        /// <summary></summary>
        public const int WM_MENURBUTTONUP = 0x0122;
        /// <summary></summary>
        public const int WM_MENUDRAG = 0x0123;
        /// <summary></summary>
        public const int WM_MENUGETOBJECT = 0x0124;
        /// <summary></summary>
        public const int WM_UNINITMENUPOPUP = 0x0125;
        /// <summary></summary>
        public const int WM_MENUCOMMAND = 0x0126;
        /// <summary></summary>
        public const int WM_CHANGEUISTATE = 0x0127;
        /// <summary></summary>
        public const int WM_UPDATEUISTATE = 0x0128;
        /// <summary></summary>
        public const int WM_QUERYUISTATE = 0x0129;
        /// <summary></summary>
        public const int WM_CTLCOLORMSGBOX = 0x0132;
        /// <summary></summary>
        public const int WM_CTLCOLOREDIT = 0x0133;
        /// <summary></summary>
        public const int WM_CTLCOLORLISTBOX = 0x0134;
        /// <summary></summary>
        public const int WM_CTLCOLORBTN = 0x0135;
        /// <summary></summary>
        public const int WM_CTLCOLORDLG = 0x0136;
        /// <summary></summary>
        public const int WM_CTLCOLORSCROLLBAR = 0x0137;
        /// <summary></summary>
        public const int WM_CTLCOLORSTATIC = 0x0138;
        /// <summary></summary>
        public const int WM_MOUSEFIRST = 0x0200;
        /// <summary></summary>
        public const int WM_MOUSEMOVE = 0x0200;
        /// <summary></summary>
        public const int WM_LBUTTONDOWN = 0x0201;
        /// <summary></summary>
        public const int WM_LBUTTONUP = 0x0202;
        /// <summary></summary>
        public const int WM_LBUTTONDBLCLK = 0x0203;
        /// <summary></summary>
        public const int WM_RBUTTONDOWN = 0x0204;
        /// <summary></summary>
        public const int WM_RBUTTONUP = 0x0205;
        /// <summary></summary>
        public const int WM_RBUTTONDBLCLK = 0x0206;
        /// <summary></summary>
        public const int WM_MBUTTONDOWN = 0x0207;
        /// <summary></summary>
        public const int WM_MBUTTONUP = 0x0208;
        /// <summary></summary>
        public const int WM_MBUTTONDBLCLK = 0x0209;
        /// <summary></summary>
        public const int WM_MOUSEWHEEL = 0x020A;
        /// <summary></summary>
        public const int WM_XBUTTONDOWN = 0x020B;
        /// <summary></summary>
        public const int WM_XBUTTONUP = 0x020C;
        /// <summary></summary>
        public const int WM_XBUTTONDBLCLK = 0x020D;
        /// <summary></summary>
        public const int WM_MOUSELAST_for2KLater = 0x020D;
        /// <summary></summary>
        public const int WM_MOUSELAST_forNT = 0x020A;
        /// <summary></summary>
        public const int WM_MOUSELAST = 0x0209;
        /// <summary></summary>
        public const int WM_PARENTNOTIFY = 0x0210;
        /// <summary></summary>
        public const int WM_ENTERMENULOOP = 0x0211;
        /// <summary></summary>
        public const int WM_EXITMENULOOP = 0x0212;
        /// <summary></summary>
        public const int WM_NEXTMENU = 0x0213;
        /// <summary></summary>
        public const int WM_SIZING = 0x0214;
        /// <summary></summary>
        public const int WM_CAPTURECHANGED = 0x0215;
        /// <summary></summary>
        public const int WM_MOVING = 0x0216;
        /// <summary></summary>
        public const int WM_POWERBROADCAST = 0x0218;
        /// <summary></summary>
        public const int WM_DEVICECHANGE = 0x0219;
        /// <summary></summary>
        public const int WM_MDICREATE = 0x0220;
        /// <summary></summary>
        public const int WM_MDIDESTROY = 0x0221;
        /// <summary></summary>
        public const int WM_MDIACTIVATE = 0x0222;
        /// <summary></summary>
        public const int WM_MDIRESTORE = 0x0223;
        /// <summary></summary>
        public const int WM_MDINEXT = 0x0224;
        /// <summary></summary>
        public const int WM_MDIMAXIMIZE = 0x0225;
        /// <summary></summary>
        public const int WM_MDITILE = 0x0226;
        /// <summary></summary>
        public const int WM_MDICASCADE = 0x0227;
        /// <summary></summary>
        public const int WM_MDIICONARRANGE = 0x0228;
        /// <summary></summary>
        public const int WM_MDIGETACTIVE = 0x0229;
        /// <summary></summary>
        public const int WM_MDISETMENU = 0x0230;
        /// <summary></summary>
        public const int WM_ENTERSIZEMOVE = 0x0231;
        /// <summary></summary>
        public const int WM_EXITSIZEMOVE = 0x0232;
        /// <summary></summary>
        public const int WM_DROPFILES = 0x0233;
        /// <summary></summary>
        public const int WM_MDIREFRESHMENU = 0x0234;
        /// <summary></summary>
        public const int WM_IME_SETCONTEXT = 0x0281;
        /// <summary></summary>
        public const int WM_IME_NOTIFY = 0x0282;
        /// <summary></summary>
        public const int WM_IME_CONTROL = 0x0283;
        /// <summary></summary>
        public const int WM_IME_COMPOSITIONFULL = 0x0284;
        /// <summary></summary>
        public const int WM_IME_SELECT = 0x0285;
        /// <summary></summary>
        public const int WM_IME_CHAR = 0x0286;
        /// <summary></summary>
        public const int WM_IME_REQUEST = 0x0288;
        /// <summary></summary>
        public const int WM_IME_KEYDOWN = 0x0290;
        /// <summary></summary>
        public const int WM_IME_KEYUP = 0x0291;
        /// <summary></summary>
        public const int WM_MOUSEHOVER = 0x02A1;
        /// <summary></summary>
        public const int WM_MOUSELEAVE = 0x02A3;
        /// <summary></summary>
        public const int WM_NCMOUSEHOVER = 0x02A0;
        /// <summary></summary>
        public const int WM_NCMOUSELEAVE = 0x02A2;
        /// <summary></summary>
        public const int WM_WTSSESSION_CHANGE = 0x02B1;
        /// <summary></summary>
        public const int WM_TABLET_FIRST = 0x02c0;
        /// <summary></summary>
        public const int WM_TABLET_LAST = 0x02df;
        /// <summary></summary>
        public const int WM_CUT = 0x0300;
        /// <summary></summary>
        public const int WM_COPY = 0x0301;
        /// <summary></summary>
        public const int WM_PASTE = 0x0302;
        /// <summary></summary>
        public const int WM_CLEAR = 0x0303;
        /// <summary></summary>
        public const int WM_UNDO = 0x0304;
        /// <summary></summary>
        public const int WM_RENDERFORMAT = 0x0305;
        /// <summary></summary>
        public const int WM_RENDERALLFORMATS = 0x0306;
        /// <summary></summary>
        public const int WM_DESTROYCLIPBOARD = 0x0307;
        /// <summary></summary>
        public const int WM_DRAWCLIPBOARD = 0x0308;
        /// <summary></summary>
        public const int WM_PAINTCLIPBOARD = 0x0309;
        /// <summary></summary>
        public const int WM_VSCROLLCLIPBOARD = 0x030A;
        /// <summary></summary>
        public const int WM_SIZECLIPBOARD = 0x030B;
        /// <summary></summary>
        public const int WM_ASKCBFORMATNAME = 0x030C;
        /// <summary></summary>
        public const int WM_CHANGECBCHAIN = 0x030D;
        /// <summary></summary>
        public const int WM_HSCROLLCLIPBOARD = 0x030E;
        /// <summary></summary>
        public const int WM_QUERYNEWPALETTE = 0x030F;
        /// <summary></summary>
        public const int WM_PALETTEISCHANGING = 0x0310;
        /// <summary></summary>
        public const int WM_PALETTECHANGED = 0x0311;
        /// <summary></summary>
        public const int WM_HOTKEY = 0x0312;
        /// <summary></summary>
        public const int WM_PRINT = 0x0317;
        /// <summary></summary>
        public const int WM_PRINTCLIENT = 0x0318;
        /// <summary></summary>
        public const int WM_APPCOMMAND = 0x0319;
        /// <summary></summary>
        public const int WM_THEMECHANGED = 0x031A;
        /// <summary></summary>
        public const int WM_HANDHELDFIRST = 0x0358;
        /// <summary></summary>
        public const int WM_HANDHELDLAST = 0x035F;
        /// <summary></summary>
        public const int WM_AFXFIRST = 0x0360;
        /// <summary></summary>
        public const int WM_AFXLAST = 0x037F;
        /// <summary></summary>
        public const int WM_PENWINFIRST = 0x0380;
        /// <summary></summary>
        public const int WM_PENWINLAST = 0x038F;
        /// <summary></summary>
        public const int WM_APP = 0x8000;
        /// <summary></summary>
        public const int WM_USER = 0x0400;
        /// <summary></summary>
        public const int WM_REFLECT = 0x2000; // 不明（WinUser.hで未定義）
    }
    #endregion

    #region HT
    /// <summary>
    /// ヒットテストコード。
    /// </summary>
    public static class HT
    {
        /// <summary></summary>
        public const int HTERROR = -2;
        /// <summary></summary>
        public const int HTTRANSPARENT = -1;
        /// <summary></summary>
        public const int HTNOWHERE = 0;
        /// <summary></summary>
        public const int HTCLIENT = 1;
        /// <summary></summary>
        public const int HTCAPTION = 2;
        /// <summary></summary>
        public const int HTSYSMENU = 3;
        /// <summary></summary>
        public const int HTGROWBOX = 4;
        /// <summary></summary>
        public const int HTSIZE = HTGROWBOX;
        /// <summary></summary>
        public const int HTMENU = 5;
        /// <summary></summary>
        public const int HTHSCROLL = 6;
        /// <summary></summary>
        public const int HTVSCROLL = 7;
        /// <summary></summary>
        public const int HTMINBUTTON = 8;
        /// <summary></summary>
        public const int HTMAXBUTTON = 9;
        /// <summary></summary>
        public const int HTLEFT = 10;
        /// <summary></summary>
        public const int HTRIGHT = 11;
        /// <summary></summary>
        public const int HTTOP = 12;
        /// <summary></summary>
        public const int HTTOPLEFT = 13;
        /// <summary></summary>
        public const int HTTOPRIGHT = 14;
        /// <summary></summary>
        public const int HTBOTTOM = 15;
        /// <summary></summary>
        public const int HTBOTTOMLEFT = 16;
        /// <summary></summary>
        public const int HTBOTTOMRIGHT = 17;
        /// <summary></summary>
        public const int HTBORDER = 18;
        /// <summary></summary>
        public const int HTREDUCE = HTMINBUTTON;
        /// <summary></summary>
        public const int HTZOOM = HTMAXBUTTON;
        /// <summary></summary>
        public const int HTSIZEFIRST = HTLEFT;
        /// <summary></summary>
        public const int HTSIZELAST = HTBOTTOMRIGHT;
        /// <summary></summary>
        public const int HTOBJECT = 19;  // WINVER >= 0x0400
        /// <summary></summary>
        public const int HTCLOSE = 20;   // WINVER >= 0x0400
        /// <summary></summary>
        public const int HTHELP = 21;    // WINVER >= 0x0400
    }
    #endregion

    #region GWL
    /// <summary>
    /// ウィンドウパラメタ。
    /// </summary>
    public static class GWL
    {
        /// <summary></summary>
        public const int GWL_WNDPROC = (-4);
        /// <summary></summary>
        public const int GWL_HINSTANCE = (-6);
        /// <summary></summary>
        public const int GWL_HWNDPARENT = (-8);
        /// <summary></summary>
        public const int GWL_STYLE = (-16);
        /// <summary></summary>
        public const int GWL_EXSTYLE = (-20);
        /// <summary></summary>
        public const int GWL_USERDATA = (-21);
        /// <summary></summary>
        public const int GWL_ID = (-12);
    }
    #endregion

    #region RDW
    /// <summary>
    /// RedrawWindow() flags。
    /// </summary>
    public static class RDW
    {
        /// <summary></summary>
        public const int RDW_INVALIDATE = 0x0001;
        /// <summary></summary>
        public const int RDW_INTERNALPAINT = 0x0002;
        /// <summary></summary>
        public const int RDW_ERASE = 0x0004;
        /// <summary></summary>
        public const int RDW_VALIDATE = 0x0008;
        /// <summary></summary>
        public const int RDW_NOINTERNALPAINT = 0x0010;
        /// <summary></summary>
        public const int RDW_NOERASE = 0x0020;
        /// <summary></summary>
        public const int RDW_NOCHILDREN = 0x0040;
        /// <summary></summary>
        public const int RDW_ALLCHILDREN = 0x0080;
        /// <summary></summary>
        public const int RDW_UPDATENOW = 0x0100;
        /// <summary></summary>
        public const int RDW_ERASENOW = 0x0200;
        /// <summary></summary>
        public const int RDW_FRAME = 0x0400;
        /// <summary></summary>
        public const int RDW_NOFRAME = 0x0800;
    }
    #endregion

    #region MA
    /// <summary>
    /// WM_MOUSEACTIVATE Return Codes。
    /// </summary>
    public static class MA
    {
        /// <summary></summary>
        public const int MA_ACTIVATE = 1;
        /// <summary></summary>
        public const int MA_ACTIVATEANDEAT = 2;
        /// <summary></summary>
        public const int MA_NOACTIVATE = 3;
        /// <summary></summary>
        public const int MA_NOACTIVATEANDEAT = 4;
    }
    #endregion

    #region MB
    /// <summary>
    /// メッセージボックスフラグ。
    /// </summary>
    public static class MB
    {
        /// <summary></summary>
        public const int MB_OK = 0x00000000;
        /// <summary></summary>
        public const int MB_OKCANCEL = 0x00000001;
        /// <summary></summary>
        public const int MB_ABORTRETRYIGNORE = 0x00000002;
        /// <summary></summary>
        public const int MB_YESNOCANCEL = 0x00000003;
        /// <summary></summary>
        public const int MB_YESNO = 0x00000004;
        /// <summary></summary>
        public const int MB_RETRYCANCEL = 0x00000005;
        /// <summary></summary>
        public const int MB_CANCELTRYCONTINUE = 0x00000006;
        /// <summary></summary>
        public const int MB_ICONHAND = 0x00000010;
        /// <summary></summary>
        public const int MB_ICONQUESTION = 0x00000020;
        /// <summary></summary>
        public const int MB_ICONEXCLAMATION = 0x00000030;
        /// <summary></summary>
        public const int MB_ICONASTERISK = 0x00000040;
        /// <summary></summary>
        public const int MB_USERICON = 0x00000080;
        /// <summary></summary>
        public const int MB_ICONWARNING = MB_ICONEXCLAMATION;
        /// <summary></summary>
        public const int MB_ICONERROR = MB_ICONHAND;
        /// <summary></summary>
        public const int MB_ICONINFORMATION = MB_ICONASTERISK;
        /// <summary></summary>
        public const int MB_ICONSTOP = MB_ICONHAND;
        /// <summary></summary>
        public const int MB_DEFBUTTON1 = 0x00000000;
        /// <summary></summary>
        public const int MB_DEFBUTTON2 = 0x00000100;
        /// <summary></summary>
        public const int MB_DEFBUTTON3 = 0x00000200;
        /// <summary></summary>
        public const int MB_DEFBUTTON4 = 0x00000300;
        /// <summary></summary>
        public const int MB_APPLMODAL = 0x00000000;
        /// <summary></summary>
        public const int MB_SYSTEMMODAL = 0x00001000;
        /// <summary></summary>
        public const int MB_TASKMODAL = 0x00002000;
        /// <summary></summary>
        public const int MB_HELP = 0x00004000; // Help Button
        /// <summary></summary>
        public const int MB_NOFOCUS = 0x00008000;
        /// <summary></summary>
        public const int MB_SETFOREGROUND = 0x00010000;
        /// <summary></summary>
        public const int MB_DEFAULT_DESKTOP_ONLY = 0x00020000;
        /// <summary></summary>
        public const int MB_TOPMOST = 0x00040000;
        /// <summary></summary>
        public const int MB_RIGHT = 0x00080000;
        /// <summary></summary>
        public const int MB_RTLREADING = 0x00100000;
        /// <summary></summary>
        public const int MB_SERVICE_NOTIFICATION_forNTLater = 0x00200000;
        /// <summary></summary>
        public const int MB_SERVICE_NOTIFICATION = 0x00040000;
        /// <summary></summary>
        public const int MB_SERVICE_NOTIFICATION_NT3X = 0x00040000;
        /// <summary></summary>
        public const int MB_TYPEMASK = 0x0000000F;
        /// <summary></summary>
        public const int MB_ICONMASK = 0x000000F0;
        /// <summary></summary>
        public const int MB_DEFMASK = 0x00000F00;
        /// <summary></summary>
        public const int MB_MODEMASK = 0x00003000;
        /// <summary></summary>
        public const int MB_MISCMASK = 0x0000C000;
    }
    #endregion

    #region MK
    /// <summary>
    /// マウスキーフラグ。
    /// </summary>
    public static class MK
    {
        /// <summary></summary>
        public const int MK_LBUTTON = 0x0001;
        /// <summary></summary>
        public const int MK_RBUTTON = 0x0002;
        /// <summary></summary>
        public const int MK_SHIFT = 0x0004;
        /// <summary></summary>
        public const int MK_CONTROL = 0x0008;
        /// <summary></summary>
        public const int MK_MBUTTON = 0x0010;
        /// <summary></summary>
        public const int MK_XBUTTON1 = 0x0020;
        /// <summary></summary>
        public const int MK_XBUTTON2 = 0x0040;
    }
    #endregion

    #region ODT
    /// <summary>
    /// オーナー描画タイプ。
    /// </summary>
    public static class ODT
    {
        /// <summary></summary>
        public const int ODT_MENU = 1;
        /// <summary></summary>
        public const int ODT_LISTBOX = 2;
        /// <summary></summary>
        public const int ODT_COMBOBOX = 3;
        /// <summary></summary>
        public const int ODT_BUTTON = 4;
        /// <summary></summary>
        public const int ODT_STATIC = 5;
    }
    #endregion

    #region ODA
    /// <summary>
    /// オーナー描画アクション。
    /// </summary>
    public static class ODA
    {
        /// <summary></summary>
        public const int ODA_DRAWENTIRE = 0x0001;
        /// <summary></summary>
        public const int ODA_SELECT = 0x0002;
        /// <summary></summary>
        public const int ODA_FOCUS = 0x0004;
    }
    #endregion

    #region ODS
    /// <summary>
    /// オーナー描画状態。
    /// </summary>
    public static class ODS
    {
        /// <summary></summary>
        public const int ODS_SELECTED = 0x0001;
        /// <summary></summary>
        public const int ODS_GRAYED = 0x0002;
        /// <summary></summary>
        public const int ODS_DISABLED = 0x0004;
        /// <summary></summary>
        public const int ODS_CHECKED = 0x0008;
        /// <summary></summary>
        public const int ODS_FOCUS = 0x0010;
        /// <summary></summary>
        public const int ODS_DEFAULT = 0x0020;
        /// <summary></summary>
        public const int ODS_COMBOBOXEDIT = 0x1000;
        /// <summary></summary>
        public const int ODS_HOTLIGHT = 0x0040;
        /// <summary></summary>
        public const int ODS_INACTIVE = 0x0080;
        /// <summary></summary>
        public const int ODS_NOACCEL = 0x0100;
        /// <summary></summary>
        public const int ODS_NOFOCUSRECT = 0x0200;
    }
    #endregion

    #region SB
    /// <summary>
    /// スクロールバーフラグ。
    /// </summary>
    public static class SB
    {
        /// <summary></summary>
        public const int SB_HORZ = 0;
        /// <summary></summary>
        public const int SB_VERT = 1;
        /// <summary></summary>
        public const int SB_CTL = 2;
        /// <summary></summary>
        public const int SB_BOTH = 3;
        /// <summary></summary>
        public const int SB_LINEUP = 0;
        /// <summary></summary>
        public const int SB_LINELEFT = 0;
        /// <summary></summary>
        public const int SB_LINEDOWN = 1;
        /// <summary></summary>
        public const int SB_LINERIGHT = 1;
        /// <summary></summary>
        public const int SB_PAGEUP = 2;
        /// <summary></summary>
        public const int SB_PAGELEFT = 2;
        /// <summary></summary>
        public const int SB_PAGEDOWN = 3;
        /// <summary></summary>
        public const int SB_PAGERIGHT = 3;
        /// <summary></summary>
        public const int SB_THUMBPOSITION = 4;
        /// <summary></summary>
        public const int SB_THUMBTRACK = 5;
        /// <summary></summary>
        public const int SB_TOP = 6;
        /// <summary></summary>
        public const int SB_LEFT = 6;
        /// <summary></summary>
        public const int SB_BOTTOM = 7;
        /// <summary></summary>
        public const int SB_RIGHT = 7;
        /// <summary></summary>
        public const int SB_ENDSCROLL = 8;
    }
    #endregion

    #region BS
    /// <summary>
    /// ボタンスタイル。
    /// </summary>
    public static class BS
    {
        /// <summary></summary>
        public const int BS_PUSHBUTTON = 0x00000000;
        /// <summary></summary>
        public const int BS_DEFPUSHBUTTON = 0x00000001;
        /// <summary></summary>
        public const int BS_CHECKBOX = 0x00000002;
        /// <summary></summary>
        public const int BS_AUTOCHECKBOX = 0x00000003;
        /// <summary></summary>
        public const int BS_RADIOBUTTON = 0x00000004;
        /// <summary></summary>
        public const int BS_3STATE = 0x00000005;
        /// <summary></summary>
        public const int BS_AUTO3STATE = 0x00000006;
        /// <summary></summary>
        public const int BS_GROUPBOX = 0x00000007;
        /// <summary></summary>
        public const int BS_USERBUTTON = 0x00000008;
        /// <summary></summary>
        public const int BS_AUTORADIOBUTTON = 0x00000009;
        /// <summary></summary>
        public const int BS_PUSHBOX = 0x0000000A;
        /// <summary></summary>
        public const int BS_OWNERDRAW = 0x0000000B;
        /// <summary></summary>
        public const int BS_TYPEMASK = 0x0000000F;
        /// <summary></summary>
        public const int BS_LEFTTEXT = 0x00000020;
        /// <summary></summary>
        public const int BS_TEXT = 0x00000000;
        /// <summary></summary>
        public const int BS_ICON = 0x00000040;
        /// <summary></summary>
        public const int BS_BITMAP = 0x00000080;
        /// <summary></summary>
        public const int BS_LEFT = 0x00000100;
        /// <summary></summary>
        public const int BS_RIGHT = 0x00000200;
        /// <summary></summary>
        public const int BS_CENTER = 0x00000300;
        /// <summary></summary>
        public const int BS_TOP = 0x00000400;
        /// <summary></summary>
        public const int BS_BOTTOM = 0x00000800;
        /// <summary></summary>
        public const int BS_VCENTER = 0x00000C00;
        /// <summary></summary>
        public const int BS_PUSHLIKE = 0x00001000;
        /// <summary></summary>
        public const int BS_MULTILINE = 0x00002000;
        /// <summary></summary>
        public const int BS_NOTIFY = 0x00004000;
        /// <summary></summary>
        public const int BS_FLAT = 0x00008000;
        /// <summary></summary>
        public const int BS_RIGHTBUTTON = BS_LEFTTEXT;
    }
    #endregion

    #region SS
    /// <summary>
    /// スタティックスタイル。
    /// </summary>
    public static class SS
    {
        /// <summary></summary>
        public const int SS_LEFT = 0x00000000;
        /// <summary></summary>
        public const int SS_CENTER = 0x00000001;
        /// <summary></summary>
        public const int SS_RIGHT = 0x00000002;
        /// <summary></summary>
        public const int SS_ICON = 0x00000003;
        /// <summary></summary>
        public const int SS_BLACKRECT = 0x00000004;
        /// <summary></summary>
        public const int SS_GRAYRECT = 0x00000005;
        /// <summary></summary>
        public const int SS_WHITERECT = 0x00000006;
        /// <summary></summary>
        public const int SS_BLACKFRAME = 0x00000007;
        /// <summary></summary>
        public const int SS_GRAYFRAME = 0x00000008;
        /// <summary></summary>
        public const int SS_WHITEFRAME = 0x00000009;
        /// <summary></summary>
        public const int SS_USERITEM = 0x0000000A;
        /// <summary></summary>
        public const int SS_SIMPLE = 0x0000000B;
        /// <summary></summary>
        public const int SS_LEFTNOWORDWRAP = 0x0000000C;
        /// <summary></summary>
        public const int SS_OWNERDRAW = 0x0000000D;
        /// <summary></summary>
        public const int SS_BITMAP = 0x0000000E;
        /// <summary></summary>
        public const int SS_ENHMETAFILE = 0x0000000F;
        /// <summary></summary>
        public const int SS_ETCHEDHORZ = 0x00000010;
        /// <summary></summary>
        public const int SS_ETCHEDVERT = 0x00000011;
        /// <summary></summary>
        public const int SS_ETCHEDFRAME = 0x00000012;
        /// <summary></summary>
        public const int SS_TYPEMASK = 0x0000001F;
        /// <summary></summary>
        public const int SS_REALSIZECONTROL = 0x00000040;
        /// <summary></summary>
        public const int SS_NOPREFIX = 0x00000080; /* Don't do "&" character translation */
        /// <summary></summary>
        public const int SS_NOTIFY = 0x00000100;
        /// <summary></summary>
        public const int SS_CENTERIMAGE = 0x00000200;
        /// <summary></summary>
        public const int SS_RIGHTJUST = 0x00000400;
        /// <summary></summary>
        public const int SS_REALSIZEIMAGE = 0x00000800;
        /// <summary></summary>
        public const int SS_SUNKEN = 0x00001000;
        /// <summary></summary>
        public const int SS_EDITCONTROL = 0x00002000;
        /// <summary></summary>
        public const int SS_ENDELLIPSIS = 0x00004000;
        /// <summary></summary>
        public const int SS_PATHELLIPSIS = 0x00008000;
        /// <summary></summary>
        public const int SS_WORDELLIPSIS = 0x0000C000;
        /// <summary></summary>
        public const int SS_ELLIPSISMASK = 0x0000C000;
    }
    #endregion

    #region VK
    /// <summary>
    /// 仮想キーコード。
    /// </summary>
    public static class VK
    {
        /// <summary></summary>
        public const int VK_LBUTTON = 0x01;
        /// <summary></summary>
        public const int VK_RBUTTON = 0x02;
        /// <summary></summary>
        public const int VK_CANCEL = 0x03;
        /// <summary></summary>
        public const int VK_MBUTTON = 0x04;     // NOT contiguous with L & RBUTTON
        /// <summary></summary>
        public const int VK_XBUTTON1 = 0x05;    // NOT contiguous with L & RBUTTON
        /// <summary></summary>
        public const int VK_XBUTTON2 = 0x06;    // NOT contiguous with L & RBUTTON
        /// <summary></summary>
        public const int VK_BACK = 0x08;
        /// <summary></summary>
        public const int VK_TAB = 0x09;
        /// <summary></summary>
        public const int VK_CLEAR = 0x0C;
        /// <summary></summary>
        public const int VK_RETURN = 0x0D;
        /// <summary></summary>
        public const int VK_SHIFT = 0x10;
        /// <summary></summary>
        public const int VK_CONTROL = 0x11;
        /// <summary></summary>
        public const int VK_MENU = 0x12;
        /// <summary></summary>
        public const int VK_PAUSE = 0x13;
        /// <summary></summary>
        public const int VK_CAPITAL = 0x14;
        /// <summary></summary>
        public const int VK_KANA = 0x15;
        /// <summary></summary>
        public const int VK_HANGEUL = 0x15;  // old name - should be here for compatibility
        /// <summary></summary>
        public const int VK_HANGUL = 0x15;
        /// <summary></summary>
        public const int VK_JUNJA = 0x17;
        /// <summary></summary>
        public const int VK_FINAL = 0x18;
        /// <summary></summary>
        public const int VK_HANJA = 0x19;
        /// <summary></summary>
        public const int VK_KANJI = 0x19;
        /// <summary></summary>
        public const int VK_ESCAPE = 0x1B;
        /// <summary></summary>
        public const int VK_CONVERT = 0x1C;
        /// <summary></summary>
        public const int VK_NONCONVERT = 0x1D;
        /// <summary></summary>
        public const int VK_ACCEPT = 0x1E;
        /// <summary></summary>
        public const int VK_MODECHANGE = 0x1F;
        /// <summary></summary>
        public const int VK_SPACE = 0x20;
        /// <summary></summary>
        public const int VK_PRIOR = 0x21;
        /// <summary></summary>
        public const int VK_NEXT = 0x22;
        /// <summary></summary>
        public const int VK_END = 0x23;
        /// <summary></summary>
        public const int VK_HOME = 0x24;
        /// <summary></summary>
        public const int VK_LEFT = 0x25;
        /// <summary></summary>
        public const int VK_UP = 0x26;
        /// <summary></summary>
        public const int VK_RIGHT = 0x27;
        /// <summary></summary>
        public const int VK_DOWN = 0x28;
        /// <summary></summary>
        public const int VK_SELECT = 0x29;
        /// <summary></summary>
        public const int VK_PRINT = 0x2A;
        /// <summary></summary>
        public const int VK_EXECUTE = 0x2B;
        /// <summary></summary>
        public const int VK_SNAPSHOT = 0x2C;
        /// <summary></summary>
        public const int VK_INSERT = 0x2D;
        /// <summary></summary>
        public const int VK_DELETE = 0x2E;
        /// <summary></summary>
        public const int VK_HELP = 0x2F;
        /// <summary></summary>
        public const int VK_LWIN = 0x5B;
        /// <summary></summary>
        public const int VK_RWIN = 0x5C;
        /// <summary></summary>
        public const int VK_APPS = 0x5D;
        /// <summary></summary>
        public const int VK_SLEEP = 0x5F;
        /// <summary></summary>
        public const int VK_NUMPAD0 = 0x60;
        /// <summary></summary>
        public const int VK_NUMPAD1 = 0x61;
        /// <summary></summary>
        public const int VK_NUMPAD2 = 0x62;
        /// <summary></summary>
        public const int VK_NUMPAD3 = 0x63;
        /// <summary></summary>
        public const int VK_NUMPAD4 = 0x64;
        /// <summary></summary>
        public const int VK_NUMPAD5 = 0x65;
        /// <summary></summary>
        public const int VK_NUMPAD6 = 0x66;
        /// <summary></summary>
        public const int VK_NUMPAD7 = 0x67;
        /// <summary></summary>
        public const int VK_NUMPAD8 = 0x68;
        /// <summary></summary>
        public const int VK_NUMPAD9 = 0x69;
        /// <summary></summary>
        public const int VK_MULTIPLY = 0x6A;
        /// <summary></summary>
        public const int VK_ADD = 0x6B;
        /// <summary></summary>
        public const int VK_SEPARATOR = 0x6C;
        /// <summary></summary>
        public const int VK_SUBTRACT = 0x6D;
        /// <summary></summary>
        public const int VK_DECIMAL = 0x6E;
        /// <summary></summary>
        public const int VK_DIVIDE = 0x6F;
        /// <summary></summary>
        public const int VK_F1 = 0x70;
        /// <summary></summary>
        public const int VK_F2 = 0x71;
        /// <summary></summary>
        public const int VK_F3 = 0x72;
        /// <summary></summary>
        public const int VK_F4 = 0x73;
        /// <summary></summary>
        public const int VK_F5 = 0x74;
        /// <summary></summary>
        public const int VK_F6 = 0x75;
        /// <summary></summary>
        public const int VK_F7 = 0x76;
        /// <summary></summary>
        public const int VK_F8 = 0x77;
        /// <summary></summary>
        public const int VK_F9 = 0x78;
        /// <summary></summary>
        public const int VK_F10 = 0x79;
        /// <summary></summary>
        public const int VK_F11 = 0x7A;
        /// <summary></summary>
        public const int VK_F12 = 0x7B;
        /// <summary></summary>
        public const int VK_F13 = 0x7C;
        /// <summary></summary>
        public const int VK_F14 = 0x7D;
        /// <summary></summary>
        public const int VK_F15 = 0x7E;
        /// <summary></summary>
        public const int VK_F16 = 0x7F;
        /// <summary></summary>
        public const int VK_F17 = 0x80;
        /// <summary></summary>
        public const int VK_F18 = 0x81;
        /// <summary></summary>
        public const int VK_F19 = 0x82;
        /// <summary></summary>
        public const int VK_F20 = 0x83;
        /// <summary></summary>
        public const int VK_F21 = 0x84;
        /// <summary></summary>
        public const int VK_F22 = 0x85;
        /// <summary></summary>
        public const int VK_F23 = 0x86;
        /// <summary></summary>
        public const int VK_F24 = 0x87;
        /// <summary></summary>
        public const int VK_NUMLOCK = 0x90;
        /// <summary></summary>
        public const int VK_SCROLL = 0x91;
        /// <summary></summary>
        public const int VK_OEM_NEC_EQUAL = 0x92;    // '=' key on numpad
        /// <summary></summary>
        public const int VK_OEM_FJ_JISHO = 0x92;     // 'Dictionary' key
        /// <summary></summary>
        public const int VK_OEM_FJ_MASSHOU = 0x93;   // 'Unregister word' key
        /// <summary></summary>
        public const int VK_OEM_FJ_TOUROKU = 0x94;   // 'Register word' key
        /// <summary></summary>
        public const int VK_OEM_FJ_LOYA = 0x95;      // 'Left OYAYUBI' key
        /// <summary></summary>
        public const int VK_OEM_FJ_ROYA = 0x96;      // 'Right OYAYUBI' key
        /// <summary></summary>
        public const int VK_LSHIFT = 0xA0;
        /// <summary></summary>
        public const int VK_RSHIFT = 0xA1;
        /// <summary></summary>
        public const int VK_LCONTROL = 0xA2;
        /// <summary></summary>
        public const int VK_RCONTROL = 0xA3;
        /// <summary></summary>
        public const int VK_LMENU = 0xA4;
        /// <summary></summary>
        public const int VK_RMENU = 0xA5;
        /// <summary></summary>
        public const int VK_BROWSER_BACK = 0xA6;
        /// <summary></summary>
        public const int VK_BROWSER_FORWARD = 0xA7;
        /// <summary></summary>
        public const int VK_BROWSER_REFRESH = 0xA8;
        /// <summary></summary>
        public const int VK_BROWSER_STOP = 0xA9;
        /// <summary></summary>
        public const int VK_BROWSER_SEARCH = 0xAA;
        /// <summary></summary>
        public const int VK_BROWSER_FAVORITES = 0xAB;
        /// <summary></summary>
        public const int VK_BROWSER_HOME = 0xAC;
        /// <summary></summary>
        public const int VK_VOLUME_MUTE = 0xAD;
        /// <summary></summary>
        public const int VK_VOLUME_DOWN = 0xAE;
        /// <summary></summary>
        public const int VK_VOLUME_UP = 0xAF;
        /// <summary></summary>
        public const int VK_MEDIA_NEXT_TRACK = 0xB0;
        /// <summary></summary>
        public const int VK_MEDIA_PREV_TRACK = 0xB1;
        /// <summary></summary>
        public const int VK_MEDIA_STOP = 0xB2;
        /// <summary></summary>
        public const int VK_MEDIA_PLAY_PAUSE = 0xB3;
        /// <summary></summary>
        public const int VK_LAUNCH_MAIL = 0xB4;
        /// <summary></summary>
        public const int VK_LAUNCH_MEDIA_SELECT = 0xB5;
        /// <summary></summary>
        public const int VK_LAUNCH_APP1 = 0xB6;
        /// <summary></summary>
        public const int VK_LAUNCH_APP2 = 0xB7;
        /// <summary></summary>
        public const int VK_OEM_1 = 0xBA;            // ';:' for US
        /// <summary></summary>
        public const int VK_OEM_PLUS = 0xBB;         // '+' any country
        /// <summary></summary>
        public const int VK_OEM_COMMA = 0xBC;        // ',' any country
        /// <summary></summary>
        public const int VK_OEM_MINUS = 0xBD;        // '-' any country
        /// <summary></summary>
        public const int VK_OEM_PERIOD = 0xBE;       // '.' any country
        /// <summary></summary>
        public const int VK_OEM_2 = 0xBF;            // '/?' for US
        /// <summary></summary>
        public const int VK_OEM_3 = 0xC0;            // '`~' for US
        /// <summary></summary>
        public const int VK_OEM_4 = 0xDB;            //  '[{' for US
        /// <summary></summary>
        public const int VK_OEM_5 = 0xDC;            //  '\|' for US
        /// <summary></summary>
        public const int VK_OEM_6 = 0xDD;            //  ']}' for US
        /// <summary></summary>
        public const int VK_OEM_7 = 0xDE;            //  ''"' for US
        /// <summary></summary>
        public const int VK_OEM_8 = 0xDF;
        /// <summary></summary>
        public const int VK_OEM_AX = 0xE1;           //  'AX' key on Japanese AX kbd
        /// <summary></summary>
        public const int VK_OEM_102 = 0xE2;          //  "<>" or "\|" on RT 102-key kbd.
        /// <summary></summary>
        public const int VK_ICO_HELP = 0xE3;         //  Help key on ICO
        /// <summary></summary>
        public const int VK_ICO_00 = 0xE4;           //  00 key on ICO
        /// <summary></summary>
        public const int VK_PROCESSKEY = 0xE5;
        /// <summary></summary>
        public const int VK_ICO_CLEAR = 0xE6;
        /// <summary></summary>
        public const int VK_PACKET = 0xE7;
        /// <summary></summary>
        public const int VK_OEM_RESET = 0xE9;
        /// <summary></summary>
        public const int VK_OEM_JUMP = 0xEA;
        /// <summary></summary>
        public const int VK_OEM_PA1 = 0xEB;
        /// <summary></summary>
        public const int VK_OEM_PA2 = 0xEC;
        /// <summary></summary>
        public const int VK_OEM_PA3 = 0xED;
        /// <summary></summary>
        public const int VK_OEM_WSCTRL = 0xEE;
        /// <summary></summary>
        public const int VK_OEM_CUSEL = 0xEF;
        /// <summary></summary>
        public const int VK_OEM_ATTN = 0xF0;
        /// <summary></summary>
        public const int VK_OEM_FINISH = 0xF1;
        /// <summary></summary>
        public const int VK_OEM_COPY = 0xF2;
        /// <summary></summary>
        public const int VK_OEM_AUTO = 0xF3;
        /// <summary></summary>
        public const int VK_OEM_ENLW = 0xF4;
        /// <summary></summary>
        public const int VK_OEM_BACKTAB = 0xF5;
        /// <summary></summary>
        public const int VK_ATTN = 0xF6;
        /// <summary></summary>
        public const int VK_CRSEL = 0xF7;
        /// <summary></summary>
        public const int VK_EXSEL = 0xF8;
        /// <summary></summary>
        public const int VK_EREOF = 0xF9;
        /// <summary></summary>
        public const int VK_PLAY = 0xFA;
        /// <summary></summary>
        public const int VK_ZOOM = 0xFB;
        /// <summary></summary>
        public const int VK_NONAME = 0xFC;
        /// <summary></summary>
        public const int VK_PA1 = 0xFD;
        /// <summary></summary>
        public const int VK_OEM_CLEAR = 0xFE;
    }
    #endregion

    #region WH
    /// <summary>
    /// WindowsHook コード。
    /// </summary>
    public static class WH
    {
        /// <summary></summary>
        public const int WH_MIN = -1;
        /// <summary></summary>
        public const int WH_MSGFILTER = -1;
        /// <summary></summary>
        public const int WH_JOURNALRECORD = 0;
        /// <summary></summary>
        public const int WH_JOURNALPLAYBACK = 1;
        /// <summary></summary>
        public const int WH_KEYBOARD = 2;
        /// <summary></summary>
        public const int WH_GETMESSAGE = 3;
        /// <summary></summary>
        public const int WH_CALLWNDPROC = 4;
        /// <summary></summary>
        public const int WH_CBT = 5;
        /// <summary></summary>
        public const int WH_SYSMSGFILTER = 6;
        /// <summary></summary>
        public const int WH_MOUSE = 7;
        /// <summary></summary>
        public const int WH_HARDWARE = 8;
        /// <summary></summary>
        public const int WH_DEBUG = 9;
        /// <summary></summary>
        public const int WH_SHELL = 10;
        /// <summary></summary>
        public const int WH_FOREGROUNDIDLE = 11;
        /// <summary></summary>
        public const int WH_CALLWNDPROCRET = 12;
        /// <summary></summary>
        public const int WH_KEYBOARD_LL = 13;
        /// <summary></summary>
        public const int WH_MOUSE_LL = 14;
        /// <summary></summary>
        public const int WH_MAX = 14;
        /// <summary></summary>
        public const int WH_MINHOOK = WH_MIN;
        /// <summary></summary>
        public const int WH_MAXHOOK = WH_MAX;

    }
    #endregion

    #region HC
    /// <summary>
    /// Hook コード。
    /// </summary>
    public static class HC
    {
        /// <summary></summary>
        public const int HC_ACTION = 0;
        /// <summary></summary>
        public const int HC_GETNEXT = 1;
        /// <summary></summary>
        public const int HC_SKIP = 2;
        /// <summary></summary>
        public const int HC_NOREMOVE = 3;
        /// <summary></summary>
        public const int HC_NOREM = HC_NOREMOVE;
        /// <summary></summary>
        public const int HC_SYSMODALON = 4;
        /// <summary></summary>
        public const int HC_SYSMODALOFF = 5;
    }
    #endregion

    #region MF
    /// <summary>
    /// メニューフラグ。
    /// </summary>
    public static class MF
    {
        /// <summary></summary>
        public const uint MF_BYCOMMAND = 0x00000000;
        /// <summary></summary>
        public const uint MF_BYPOSITION = 0x00000400;

        /// <summary></summary>
        public const uint MF_ENABLED = 0x00000000;
        /// <summary></summary>
        public const uint MF_GRAYED = 0x00000001;
        /// <summary></summary>
        public const uint MF_DISABLED = 0x00000002;
    }
    #endregion

    #region SC
    /// <summary>
    /// システムメニューコマンド。
    /// </summary>
    public static class SC
    {
        /// <summary></summary>
        public const int SC_SIZE = 0xF000;
        /// <summary></summary>
        public const int SC_MOVE = 0xF010;
        /// <summary></summary>
        public const int SC_MINIMIZE = 0xF020;
        /// <summary></summary>
        public const int SC_MAXIMIZE = 0xF030;
        /// <summary></summary>
        public const int SC_NEXTWINDOW = 0xF040;
        /// <summary></summary>
        public const int SC_PREVWINDOW = 0xF050;
        /// <summary></summary>
        public const int SC_CLOSE = 0xF060;
        /// <summary></summary>
        public const int SC_VSCROLL = 0xF070;
        /// <summary></summary>
        public const int SC_HSCROLL = 0xF080;
        /// <summary></summary>
        public const int SC_MOUSEMENU = 0xF090;
        /// <summary></summary>
        public const int SC_KEYMENU = 0xF100;
        /// <summary></summary>
        public const int SC_ARRANGE = 0xF110;
        /// <summary></summary>
        public const int SC_RESTORE = 0xF120;
        /// <summary></summary>
        public const int SC_TASKLIST = 0xF130;
        /// <summary></summary>
        public const int SC_SCREENSAVE = 0xF140;
        /// <summary></summary>
        public const int SC_DEFAULT = 0xF160;           // WINVER >= 0x0400
        /// <summary></summary>
        public const int SC_MONITORPOWER = 0xF170;      // WINVER >= 0x0400
        /// <summary></summary>
        public const int SC_CONTEXTHELP = 0xF180;       // WINVER >= 0x0400
        /// <summary></summary>
        public const int SC_SEPARATOR = 0xF00F;         // WINVER >= 0x0400
    }
    #endregion

    //---------------------------------------------------------------------
    // WinGDI.h
    //---------------------------------------------------------------------
    #region R2
    /// <summary>
    /// バイナリラスタ操作フラグ。
    /// </summary>
    public static class R2
    {
        /// <summary></summary>
        public const int R2_BLACK = 1;            // 0
        /// <summary></summary>
        public const int R2_NOTMERGEPEN = 2;      // DPon
        /// <summary></summary>
        public const int R2_MASKNOTPEN = 3;       // DPna
        /// <summary></summary>
        public const int R2_NOTCOPYPEN = 4;       // PN
        /// <summary></summary>
        public const int R2_MASKPENNOT = 5;       // PDna
        /// <summary></summary>
        public const int R2_NOT = 6;              // Dn
        /// <summary></summary>
        public const int R2_XORPEN = 7;           // DPx
        /// <summary></summary>
        public const int R2_NOTMASKPEN = 8;       // DPan
        /// <summary></summary>
        public const int R2_MASKPEN = 9;          // DPa
        /// <summary></summary>
        public const int R2_NOTXORPEN = 10;       // DPxn
        /// <summary></summary>
        public const int R2_NOP = 11;             // D
        /// <summary></summary>
        public const int R2_MERGENOTPEN = 12;     // DPno
        /// <summary></summary>
        public const int R2_COPYPEN = 13;         // P
        /// <summary></summary>
        public const int R2_MERGEPENNOT = 14;     // PDno
        /// <summary></summary>
        public const int R2_MERGEPEN = 15;        // DPo
        /// <summary></summary>
        public const int R2_WHITE = 16;           // 1
        /// <summary></summary>
        public const int R2_LAST = 16;
    }
    #endregion

    #region RGN
    /// <summary>
    /// CombineRgn() Styles。
    /// </summary>
    public static class RGN
    {
        /// <summary></summary>
        public const int RGN_AND = 1;
        /// <summary></summary>
        public const int RGN_OR = 2;
        /// <summary></summary>
        public const int RGN_XOR = 3;
        /// <summary></summary>
        public const int RGN_DIFF = 4;
        /// <summary></summary>
        public const int RGN_COPY = 5;
        /// <summary></summary>
        public const int RGN_MIN = RGN_AND;
        /// <summary></summary>
        public const int RGN_MAX = RGN_COPY;
    }
    #endregion

    #region RGNF
    /// <summary>
    /// Region Flags。
    /// </summary>
    public static class RGNF
    {
        /// <summary></summary>
        public const int ERROR = 0;
        /// <summary></summary>
        public const int NULLREGION = 1;
        /// <summary></summary>
        public const int SIMPLEREGION = 2;
        /// <summary></summary>
        public const int COMPLEXREGION = 3;
    }
    #endregion

    #region ROP
    /// <summary>
    /// ラスタ操作フラグ。
    /// </summary>
    public static class ROP
    {
        /// <summary></summary>
        public const int SRCCOPY = 0x00CC0020;             // dest = source
        /// <summary></summary>
        public const int SRCPAINT = 0x00EE0086;            // dest = source OR dest
        /// <summary></summary>
        public const int SRCAND = 0x008800C6;              // dest = source AND dest
        /// <summary></summary>
        public const int SRCINVERT = 0x00660046;           // dest = source XOR dest
        /// <summary></summary>
        public const int SRCERASE = 0x00440328;            // dest = source AND (NOT dest)
        /// <summary></summary>
        public const int NOTSRCCOPY = 0x00330008;          // dest = (NOT source)
        /// <summary></summary>
        public const int NOTSRCERASE = 0x001100A6;         // dest = (NOT src) AND (NOT dest)
        /// <summary></summary>
        public const int MERGECOPY = 0x00C000CA;           // dest = (source AND pattern)
        /// <summary></summary>
        public const int MERGEPAINT = 0x00BB0226;          // dest = (NOT source) OR dest
        /// <summary></summary>
        public const int PATCOPY = 0x00F00021;             // dest = pattern
        /// <summary></summary>
        public const int PATPAINT = 0x00FB0A09;            // dest = DPSnoo
        /// <summary></summary>
        public const int PATINVERT = 0x005A0049;           // dest = pattern XOR dest
        /// <summary></summary>
        public const int DSTINVERT = 0x00550009;           // dest = (NOT dest)
        /// <summary></summary>
        public const int BLACKNESS = 0x00000042;           // dest = BLACK
        /// <summary></summary>
        public const int WHITENESS = 0x00FF0062;           // dest = WHITE
        /// <summary></summary>
        public const int NOMIRRORBITMAP = unchecked((int)0x80000000); // Do not Mirror the bitmap in this call
        /// <summary></summary>
        public const int CAPTUREBLT = 0x40000000;          // Include layered windows
    }
    #endregion

    //---------------------------------------------------------------------
    // CommCtrl.h
    //---------------------------------------------------------------------
    #region NM
    /// <summary>
    /// 通知コード。
    /// </summary>
    public static class NM
    {
        /// <summary></summary>
        public const int NM_FIRST = (0 - 0);                     // generic to all controls
        /// <summary></summary>
        public const int NM_LAST = (0 - 99);
        /// <summary></summary>
        public const int NM_OUTOFMEMORY = (NM_FIRST - 1);
        /// <summary></summary>
        public const int NM_CLICK = (NM_FIRST - 2);              // uses NMCLICK struct
        /// <summary></summary>
        public const int NM_DBLCLK = (NM_FIRST - 3);
        /// <summary></summary>
        public const int NM_RETURN = (NM_FIRST - 4);
        /// <summary></summary>
        public const int NM_RCLICK = (NM_FIRST - 5);             // uses NMCLICK struct
        /// <summary></summary>
        public const int NM_RDBLCLK = (NM_FIRST - 6);
        /// <summary></summary>
        public const int NM_SETFOCUS = (NM_FIRST - 7);
        /// <summary></summary>
        public const int NM_KILLFOCUS = (NM_FIRST - 8);
        /// <summary></summary>
        public const int NM_CUSTOMDRAW = (NM_FIRST - 12);
        /// <summary></summary>
        public const int NM_HOVER = (NM_FIRST - 13);
        /// <summary></summary>
        public const int NM_NCHITTEST = (NM_FIRST - 14);         // uses NMMOUSE struct
        /// <summary></summary>
        public const int NM_KEYDOWN = (NM_FIRST - 15);           // uses NMKEY struct
        /// <summary></summary>
        public const int NM_RELEASEDCAPTURE = (NM_FIRST - 16);
        /// <summary></summary>
        public const int NM_SETCURSOR = (NM_FIRST - 17);         // uses NMMOUSE struct
        /// <summary></summary>
        public const int NM_CHAR = (NM_FIRST - 18);              // uses NMCHAR struct
        /// <summary></summary>
        public const int NM_TOOLTIPSCREATED = (NM_FIRST - 19);   // notify of when the tooltips window is create
        /// <summary></summary>
        public const int NM_LDOWN = (NM_FIRST - 20);
        /// <summary></summary>
        public const int NM_RDOWN = (NM_FIRST - 21);
        /// <summary></summary>
        public const int NM_THEMECHANGED = (NM_FIRST - 22);
    }
    #endregion

    #region CDRF
    /// <summary>
    /// カスタム描画戻り値フラグ。
    /// </summary>
    public static class CDRF
    {
        /// <summary></summary>
        public const int CDRF_DODEFAULT = 0x00000000;
        /// <summary></summary>
        public const int CDRF_NEWFONT = 0x00000002;
        /// <summary></summary>
        public const int CDRF_SKIPDEFAULT = 0x00000004;
        /// <summary></summary>
        public const int CDRF_NOTIFYPOSTPAINT = 0x00000010;
        /// <summary></summary>
        public const int CDRF_NOTIFYITEMDRAW = 0x00000020;
        /// <summary></summary>
        public const int CDRF_NOTIFYSUBITEMDRAW = 0x00000020; // flags are the same, we can distinguish by context
        /// <summary></summary>
        public const int CDRF_NOTIFYPOSTERASE = 0x00000040;
    }
    #endregion

    #region CDDS
    /// <summary>
    /// カスタム描画ステージフラグ。
    /// </summary>
    public static class CDDS
    {
        /// <summary></summary>
        public const int CDDS_PREPAINT = 0x00000001;
        /// <summary></summary>
        public const int CDDS_POSTPAINT = 0x00000002;
        /// <summary></summary>
        public const int CDDS_PREERASE = 0x00000003;
        /// <summary></summary>
        public const int CDDS_POSTERASE = 0x00000004;
        /// <summary></summary>
        public const int CDDS_ITEM = 0x00010000;
        /// <summary></summary>
        public const int CDDS_ITEMPREPAINT = (CDDS_ITEM | CDDS_PREPAINT);
        /// <summary></summary>
        public const int CDDS_ITEMPOSTPAINT = (CDDS_ITEM | CDDS_POSTPAINT);
        /// <summary></summary>
        public const int CDDS_ITEMPREERASE = (CDDS_ITEM | CDDS_PREERASE);
        /// <summary></summary>
        public const int CDDS_ITEMPOSTERASE = (CDDS_ITEM | CDDS_POSTERASE);
        /// <summary></summary>
        public const int CDDS_SUBITEM = 0x00020000;
        /// <summary></summary>
        public const int CDDS_SUBITEMPREPAINT = (CDDS_ITEM | CDDS_SUBITEM | CDDS_PREPAINT);
        /// <summary></summary>
        public const int CDDS_SUBITEMPOSTPAINT = (CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTPAINT);
        /// <summary></summary>
        public const int CDDS_SUBITEMPREERASE = (CDDS_ITEM | CDDS_SUBITEM | CDDS_PREERASE);
        /// <summary></summary>
        public const int CDDS_SUBITEMPOSTERASE = (CDDS_ITEM | CDDS_SUBITEM | CDDS_POSTERASE);
    }
    #endregion

    #region CDIS
    /// <summary>
    /// カスタム描画項目状態。
    /// </summary>
    public static class CDIS
    {
        /// <summary></summary>
        public const int CDIS_SELECTED = 0x0001;
        /// <summary></summary>
        public const int CDIS_GRAYED = 0x0002;
        /// <summary></summary>
        public const int CDIS_DISABLED = 0x0004;
        /// <summary></summary>
        public const int CDIS_CHECKED = 0x0008;
        /// <summary></summary>
        public const int CDIS_FOCUS = 0x0010;
        /// <summary></summary>
        public const int CDIS_DEFAULT = 0x0020;
        /// <summary></summary>
        public const int CDIS_HOT = 0x0040;
        /// <summary></summary>
        public const int CDIS_MARKED = 0x0080;
        /// <summary></summary>
        public const int CDIS_INDETERMINATE = 0x0100;
        /// <summary></summary>
        public const int CDIS_SHOWKEYBOARDCUES = 0x0200;
    }
    #endregion

    #region LVS
    /// <summary>
    /// リストビュースタイル。
    /// </summary>
    public static class LVS
    {
        /// <summary></summary>
        public const int LVS_ICON = 0x0000;
        /// <summary></summary>
        public const int LVS_REPORT = 0x0001;
        /// <summary></summary>
        public const int LVS_SMALLICON = 0x0002;
        /// <summary></summary>
        public const int LVS_LIST = 0x0003;
        /// <summary></summary>
        public const int LVS_TYPEMASK = 0x0003;
        /// <summary></summary>
        public const int LVS_SINGLESEL = 0x0004;
        /// <summary></summary>
        public const int LVS_SHOWSELALWAYS = 0x0008;
        /// <summary></summary>
        public const int LVS_SORTASCENDING = 0x0010;
        /// <summary></summary>
        public const int LVS_SORTDESCENDING = 0x0020;
        /// <summary></summary>
        public const int LVS_SHAREIMAGELISTS = 0x0040;
        /// <summary></summary>
        public const int LVS_NOLABELWRAP = 0x0080;
        /// <summary></summary>
        public const int LVS_AUTOARRANGE = 0x0100;
        /// <summary></summary>
        public const int LVS_EDITLABELS = 0x0200;
        /// <summary></summary>
        public const int LVS_OWNERDATA = 0x1000;
        /// <summary></summary>
        public const int LVS_NOSCROLL = 0x2000;
        /// <summary></summary>
        public const int LVS_TYPESTYLEMASK = 0xfc00;
        /// <summary></summary>
        public const int LVS_ALIGNTOP = 0x0000;
        /// <summary></summary>
        public const int LVS_ALIGNLEFT = 0x0800;
        /// <summary></summary>
        public const int LVS_ALIGNMASK = 0x0c00;
        /// <summary></summary>
        public const int LVS_OWNERDRAWFIXED = 0x0400;
        /// <summary></summary>
        public const int LVS_NOCOLUMNHEADER = 0x4000;
        /// <summary></summary>
        public const int LVS_NOSORTHEADER = 0x8000;
    }
    #endregion

    #region LVS_EX
    /// <summary>
    /// リストビュー拡張スタイル。
    /// </summary>
    public static class LVS_EX
    {
        /// <summary></summary>
        public const int LVS_EX_GRIDLINES = 0x00000001;
        /// <summary></summary>
        public const int LVS_EX_SUBITEMIMAGES = 0x00000002;
        /// <summary></summary>
        public const int LVS_EX_CHECKBOXES = 0x00000004;
        /// <summary></summary>
        public const int LVS_EX_TRACKSELECT = 0x00000008;
        /// <summary></summary>
        public const int LVS_EX_HEADERDRAGDROP = 0x00000010;
        /// <summary></summary>
        public const int LVS_EX_FULLROWSELECT = 0x00000020;    // applies to report mode only
        /// <summary></summary>
        public const int LVS_EX_ONECLICKACTIVATE = 0x00000040;
        /// <summary></summary>
        public const int LVS_EX_TWOCLICKACTIVATE = 0x00000080;
        /// <summary></summary>
        public const int LVS_EX_FLATSB = 0x00000100;
        /// <summary></summary>
        public const int LVS_EX_REGIONAL = 0x00000200;
        /// <summary></summary>
        public const int LVS_EX_INFOTIP = 0x00000400;          // listview does InfoTips for you
        /// <summary></summary>
        public const int LVS_EX_UNDERLINEHOT = 0x00000800;
        /// <summary></summary>
        public const int LVS_EX_UNDERLINECOLD = 0x00001000;
        /// <summary></summary>
        public const int LVS_EX_MULTIWORKAREAS = 0x00002000;
        /// <summary></summary>
        public const int LVS_EX_LABELTIP = 0x00004000;         // listview unfolds partly hidden labels if it does not have infotip text
        /// <summary></summary>
        public const int LVS_EX_BORDERSELECT = 0x00008000;     // border selection style instead of highlight
        /// <summary></summary>
        public const int LVS_EX_DOUBLEBUFFER = 0x00010000;
        /// <summary></summary>
        public const int LVS_EX_HIDELABELS = 0x00020000;
        /// <summary></summary>
        public const int LVS_EX_SINGLEROW = 0x00040000;
        /// <summary></summary>
        public const int LVS_EX_SNAPTOGRID = 0x00080000;       // Icons automatically snap to grid.
    }
    #endregion

    #region LVM
    /// <summary>
    /// リストビューメッセージ。
    /// </summary>
    public static class LVM
    {
        /// <summary></summary>
        public const int LVM_FIRST = 0x1000; // ListView messages
        /// <summary></summary>
        public const int LVM_GETBKCOLOR = (LVM_FIRST + 0);
        /// <summary></summary>
        public const int LVM_SETBKCOLOR = (LVM_FIRST + 1);
        /// <summary></summary>
        public const int LVM_GETIMAGELIST = (LVM_FIRST + 2);
        /// <summary></summary>
        public const int LVM_SETIMAGELIST = (LVM_FIRST + 3);
        /// <summary></summary>
        public const int LVM_GETITEMCOUNT = (LVM_FIRST + 4);
        /// <summary></summary>
        public const int LVM_GETITEMA = (LVM_FIRST + 5);
        /// <summary></summary>
        public const int LVM_GETITEMW = (LVM_FIRST + 75);
        /// <summary></summary>
        public const int LVM_SETITEMA = (LVM_FIRST + 6);
        /// <summary></summary>
        public const int LVM_SETITEMW = (LVM_FIRST + 76);
        /// <summary></summary>
        public const int LVM_INSERTITEMA = (LVM_FIRST + 7);
        /// <summary></summary>
        public const int LVM_INSERTITEMW = (LVM_FIRST + 77);
        /// <summary></summary>
        public const int LVM_DELETEITEM = (LVM_FIRST + 8);
        /// <summary></summary>
        public const int LVM_DELETEALLITEMS = (LVM_FIRST + 9);
        /// <summary></summary>
        public const int LVM_GETCALLBACKMASK = (LVM_FIRST + 10);
        /// <summary></summary>
        public const int LVM_SETCALLBACKMASK = (LVM_FIRST + 11);
        /// <summary></summary>
        public const int LVM_GETNEXTITEM = (LVM_FIRST + 12);
        /// <summary></summary>
        public const int LVM_FINDITEMA = (LVM_FIRST + 13);
        /// <summary></summary>
        public const int LVM_FINDITEMW = (LVM_FIRST + 83);
        /// <summary></summary>
        public const int LVM_GETITEMRECT = (LVM_FIRST + 14);
        /// <summary></summary>
        public const int LVM_SETITEMPOSITION = (LVM_FIRST + 15);
        /// <summary></summary>
        public const int LVM_GETITEMPOSITION = (LVM_FIRST + 16);
        /// <summary></summary>
        public const int LVM_GETSTRINGWIDTHA = (LVM_FIRST + 17);
        /// <summary></summary>
        public const int LVM_GETSTRINGWIDTHW = (LVM_FIRST + 87);
        /// <summary></summary>
        public const int LVM_HITTEST = (LVM_FIRST + 18);
        /// <summary></summary>
        public const int LVM_ENSUREVISIBLE = (LVM_FIRST + 19);
        /// <summary></summary>
        public const int LVM_SCROLL = (LVM_FIRST + 20);
        /// <summary></summary>
        public const int LVM_REDRAWITEMS = (LVM_FIRST + 21);
        /// <summary></summary>
        public const int LVM_ARRANGE = (LVM_FIRST + 22);
        /// <summary></summary>
        public const int LVM_EDITLABELA = (LVM_FIRST + 23);
        /// <summary></summary>
        public const int LVM_EDITLABELW = (LVM_FIRST + 118);
        /// <summary></summary>
        public const int LVM_GETEDITCONTROL = (LVM_FIRST + 24);
        /// <summary></summary>
        public const int LVM_GETCOLUMNA = (LVM_FIRST + 25);
        /// <summary></summary>
        public const int LVM_GETCOLUMNW = (LVM_FIRST + 95);
        /// <summary></summary>
        public const int LVM_SETCOLUMNA = (LVM_FIRST + 26);
        /// <summary></summary>
        public const int LVM_SETCOLUMNW = (LVM_FIRST + 96);
        /// <summary></summary>
        public const int LVM_INSERTCOLUMNA = (LVM_FIRST + 27);
        /// <summary></summary>
        public const int LVM_INSERTCOLUMNW = (LVM_FIRST + 97);
        /// <summary></summary>
        public const int LVM_DELETECOLUMN = (LVM_FIRST + 28);
        /// <summary></summary>
        public const int LVM_GETCOLUMNWIDTH = (LVM_FIRST + 29);
        /// <summary></summary>
        public const int LVM_SETCOLUMNWIDTH = (LVM_FIRST + 30);
        /// <summary></summary>
        public const int LVM_GETHEADER = (LVM_FIRST + 31);
        /// <summary></summary>
        public const int LVM_CREATEDRAGIMAGE = (LVM_FIRST + 33);
        /// <summary></summary>
        public const int LVM_GETVIEWRECT = (LVM_FIRST + 34);
        /// <summary></summary>
        public const int LVM_GETTEXTCOLOR = (LVM_FIRST + 35);
        /// <summary></summary>
        public const int LVM_SETTEXTCOLOR = (LVM_FIRST + 36);
        /// <summary></summary>
        public const int LVM_GETTEXTBKCOLOR = (LVM_FIRST + 37);
        /// <summary></summary>
        public const int LVM_SETTEXTBKCOLOR = (LVM_FIRST + 38);
        /// <summary></summary>
        public const int LVM_GETTOPINDEX = (LVM_FIRST + 39);
        /// <summary></summary>
        public const int LVM_GETCOUNTPERPAGE = (LVM_FIRST + 40);
        /// <summary></summary>
        public const int LVM_GETORIGIN = (LVM_FIRST + 41);
        /// <summary></summary>
        public const int LVM_UPDATE = (LVM_FIRST + 42);
        /// <summary></summary>
        public const int LVM_SETITEMSTATE = (LVM_FIRST + 43);
        /// <summary></summary>
        public const int LVM_GETITEMSTATE = (LVM_FIRST + 44);
        /// <summary></summary>
        public const int LVM_GETITEMTEXTA = (LVM_FIRST + 45);
        /// <summary></summary>
        public const int LVM_GETITEMTEXTW = (LVM_FIRST + 115);
        /// <summary></summary>
        public const int LVM_SETITEMTEXTA = (LVM_FIRST + 46);
        /// <summary></summary>
        public const int LVM_SETITEMTEXTW = (LVM_FIRST + 116);
        /// <summary></summary>
        public const int LVM_SETITEMCOUNT = (LVM_FIRST + 47);
        /// <summary></summary>
        public const int LVM_SORTITEMS = (LVM_FIRST + 48);
        /// <summary></summary>
        public const int LVM_SETITEMPOSITION32 = (LVM_FIRST + 49);
        /// <summary></summary>
        public const int LVM_GETSELECTEDCOUNT = (LVM_FIRST + 50);
        /// <summary></summary>
        public const int LVM_GETITEMSPACING = (LVM_FIRST + 51);
        /// <summary></summary>
        public const int LVM_GETISEARCHSTRINGA = (LVM_FIRST + 52);
        /// <summary></summary>
        public const int LVM_GETISEARCHSTRINGW = (LVM_FIRST + 117);
        /// <summary></summary>
        public const int LVM_SETICONSPACING = (LVM_FIRST + 53);
        /// <summary></summary>
        public const int LVM_SETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 54);   // optional wParam == mask
        /// <summary></summary>
        public const int LVM_GETEXTENDEDLISTVIEWSTYLE = (LVM_FIRST + 55);
        /// <summary></summary>
        public const int LVM_GETSUBITEMRECT = (LVM_FIRST + 56);
        /// <summary></summary>
        public const int LVM_SUBITEMHITTEST = (LVM_FIRST + 57);
        /// <summary></summary>
        public const int LVM_SETCOLUMNORDERARRAY = (LVM_FIRST + 58);
        /// <summary></summary>
        public const int LVM_GETCOLUMNORDERARRAY = (LVM_FIRST + 59);
        /// <summary></summary>
        public const int LVM_SETHOTITEM = (LVM_FIRST + 60);
        /// <summary></summary>
        public const int LVM_GETHOTITEM = (LVM_FIRST + 61);
        /// <summary></summary>
        public const int LVM_SETHOTCURSOR = (LVM_FIRST + 62);
        /// <summary></summary>
        public const int LVM_GETHOTCURSOR = (LVM_FIRST + 63);
        /// <summary></summary>
        public const int LVM_APPROXIMATEVIEWRECT = (LVM_FIRST + 64);
        /// <summary></summary>
        public const int LVM_SETWORKAREAS = (LVM_FIRST + 65);
        /// <summary></summary>
        public const int LVM_GETSELECTIONMARK = (LVM_FIRST + 66);
        /// <summary></summary>
        public const int LVM_SETSELECTIONMARK = (LVM_FIRST + 67);
        /// <summary></summary>
        public const int LVM_SETBKIMAGEA = (LVM_FIRST + 68);
        /// <summary></summary>
        public const int LVM_SETBKIMAGEW = (LVM_FIRST + 138);
        /// <summary></summary>
        public const int LVM_GETBKIMAGEA = (LVM_FIRST + 69);
        /// <summary></summary>
        public const int LVM_GETBKIMAGEW = (LVM_FIRST + 139);
        /// <summary></summary>
        public const int LVM_GETWORKAREAS = (LVM_FIRST + 70);
        /// <summary></summary>
        public const int LVM_SETHOVERTIME = (LVM_FIRST + 71);
        /// <summary></summary>
        public const int LVM_GETHOVERTIME = (LVM_FIRST + 72);
        /// <summary></summary>
        public const int LVM_GETNUMBEROFWORKAREAS = (LVM_FIRST + 73);
        /// <summary></summary>
        public const int LVM_SETTOOLTIPS = (LVM_FIRST + 74);
        /// <summary></summary>
        public const int LVM_GETTOOLTIPS = (LVM_FIRST + 78);
        /// <summary></summary>
        public const int LVM_SORTITEMSEX = (LVM_FIRST + 81);
        /// <summary></summary>
        public const int LVM_SETSELECTEDCOLUMN = (LVM_FIRST + 140);
        /// <summary></summary>
        public const int LVM_SETTILEWIDTH = (LVM_FIRST + 141);
        /// <summary></summary>
        public const int LVM_SETVIEW = (LVM_FIRST + 142);
        /// <summary></summary>
        public const int LVM_GETVIEW = (LVM_FIRST + 143);
        /// <summary></summary>
        public const int LVM_INSERTGROUP = (LVM_FIRST + 145);
        /// <summary></summary>
        public const int LVM_SETGROUPINFO = (LVM_FIRST + 147);
        /// <summary></summary>
        public const int LVM_GETGROUPINFO = (LVM_FIRST + 149);
        /// <summary></summary>
        public const int LVM_REMOVEGROUP = (LVM_FIRST + 150);
        /// <summary></summary>
        public const int LVM_MOVEGROUP = (LVM_FIRST + 151);
        /// <summary></summary>
        public const int LVM_MOVEITEMTOGROUP = (LVM_FIRST + 154);
        /// <summary></summary>
        public const int LVM_SETGROUPMETRICS = (LVM_FIRST + 155);
        /// <summary></summary>
        public const int LVM_GETGROUPMETRICS = (LVM_FIRST + 156);
        /// <summary></summary>
        public const int LVM_ENABLEGROUPVIEW = (LVM_FIRST + 157);
        /// <summary></summary>
        public const int LVM_SORTGROUPS = (LVM_FIRST + 158);
        /// <summary></summary>
        public const int LVM_INSERTGROUPSORTED = (LVM_FIRST + 159);
        /// <summary></summary>
        public const int LVM_REMOVEALLGROUPS = (LVM_FIRST + 160);
        /// <summary></summary>
        public const int LVM_HASGROUP = (LVM_FIRST + 161);
        /// <summary></summary>
        public const int LVM_SETTILEVIEWINFO = (LVM_FIRST + 162);
        /// <summary></summary>
        public const int LVM_GETTILEVIEWINFO = (LVM_FIRST + 163);
        /// <summary></summary>
        public const int LVM_SETTILEINFO = (LVM_FIRST + 164);
        /// <summary></summary>
        public const int LVM_GETTILEINFO = (LVM_FIRST + 165);
        /// <summary></summary>
        public const int LVM_SETINSERTMARK = (LVM_FIRST + 166);
        /// <summary></summary>
        public const int LVM_GETINSERTMARK = (LVM_FIRST + 167);
        /// <summary></summary>
        public const int LVM_INSERTMARKHITTEST = (LVM_FIRST + 168);
        /// <summary></summary>
        public const int LVM_GETINSERTMARKRECT = (LVM_FIRST + 169);
        /// <summary></summary>
        public const int LVM_SETINSERTMARKCOLOR = (LVM_FIRST + 170);
        /// <summary></summary>
        public const int LVM_GETINSERTMARKCOLOR = (LVM_FIRST + 171);
        /// <summary></summary>
        public const int LVM_SETINFOTIP = (LVM_FIRST + 173);
        /// <summary></summary>
        public const int LVM_GETSELECTEDCOLUMN = (LVM_FIRST + 174);
        /// <summary></summary>
        public const int LVM_ISGROUPVIEWENABLED = (LVM_FIRST + 175);
        /// <summary></summary>
        public const int LVM_GETOUTLINECOLOR = (LVM_FIRST + 176);
        /// <summary></summary>
        public const int LVM_SETOUTLINECOLOR = (LVM_FIRST + 177);
        /// <summary></summary>
        public const int LVM_CANCELEDITLABEL = (LVM_FIRST + 179);
        /// <summary></summary>
        public const int LVM_MAPINDEXTOID = (LVM_FIRST + 180);
        /// <summary></summary>
        public const int LVM_MAPIDTOINDEX = (LVM_FIRST + 181);
    }
    #endregion

    #region LVIR
    /// <summary>
    /// リストビュー項目領域。
    /// </summary>
    public static class LVIR
    {
        /// <summary></summary>
        public const int LVIR_BOUNDS = 0;
        /// <summary></summary>
        public const int LVIR_ICON = 1;
        /// <summary></summary>
        public const int LVIR_LABEL = 2;
        /// <summary></summary>
        public const int LVIR_SELECTBOUNDS = 3;
    }
    #endregion

    #region HDS
    /// <summary>
    /// ヘッダースタイル。
    /// </summary>
    public static class HDS
    {
        /// <summary></summary>
        public const int HDS_HORZ = 0x0000;
        /// <summary></summary>
        public const int HDS_BUTTONS = 0x0002;
        /// <summary></summary>
        public const int HDS_HOTTRACK = 0x0004;
        /// <summary></summary>
        public const int HDS_HIDDEN = 0x0008;
        /// <summary></summary>
        public const int HDS_DRAGDROP = 0x0040;
        /// <summary></summary>
        public const int HDS_FULLDRAG = 0x0080;
        /// <summary></summary>
        public const int HDS_FILTERBAR = 0x0100;
        /// <summary></summary>
        public const int HDS_FLAT = 0x0200;
    }
    #endregion

    #region HDM
    /// <summary>
    /// ヘッダーメッセージ。
    /// </summary>
    public static class HDM
    {
        /// <summary></summary>
        public const int HDM_FIRST = 0x1200;      // Header messages
        /// <summary></summary>
        public const int HDM_GETITEMCOUNT = (HDM_FIRST + 0);
        /// <summary></summary>
        public const int HDM_INSERTITEMA = (HDM_FIRST + 1);
        /// <summary></summary>
        public const int HDM_INSERTITEMW = (HDM_FIRST + 10);
        /// <summary></summary>
        public const int HDM_DELETEITEM = (HDM_FIRST + 2);
        /// <summary></summary>
        public const int HDM_GETITEMA = (HDM_FIRST + 3);
        /// <summary></summary>
        public const int HDM_GETITEMW = (HDM_FIRST + 11);
        /// <summary></summary>
        public const int HDM_SETITEMA = (HDM_FIRST + 4);
        /// <summary></summary>
        public const int HDM_SETITEMW = (HDM_FIRST + 12);
        /// <summary></summary>
        public const int HDM_LAYOUT = (HDM_FIRST + 5);
        /// <summary></summary>
        public const int HDM_HITTEST = (HDM_FIRST + 6);
        /// <summary></summary>
        public const int HDM_GETITEMRECT = (HDM_FIRST + 7);
        /// <summary></summary>
        public const int HDM_SETIMAGELIST = (HDM_FIRST + 8);
        /// <summary></summary>
        public const int HDM_GETIMAGELIST = (HDM_FIRST + 9);
        /// <summary></summary>
        public const int HDM_ORDERTOINDEX = (HDM_FIRST + 15);
        /// <summary></summary>
        public const int HDM_CREATEDRAGIMAGE = (HDM_FIRST + 16);  // wparam = which item (by index);
        /// <summary></summary>
        public const int HDM_GETORDERARRAY = (HDM_FIRST + 17);
        /// <summary></summary>
        public const int HDM_SETORDERARRAY = (HDM_FIRST + 18);
        /// <summary></summary>
        public const int HDM_SETHOTDIVIDER = (HDM_FIRST + 19);
        /// <summary></summary>
        public const int HDM_SETBITMAPMARGIN = (HDM_FIRST + 20);
        /// <summary></summary>
        public const int HDM_GETBITMAPMARGIN = (HDM_FIRST + 21);
        /// <summary></summary>
        public const int HDM_SETFILTERCHANGETIMEOUT = (HDM_FIRST + 22);
        /// <summary></summary>
        public const int HDM_EDITFILTER = (HDM_FIRST + 23);
        /// <summary></summary>
        public const int HDM_CLEARFILTER = (HDM_FIRST + 24);
    }
    #endregion

    #region HDN
    /// <summary>
    /// ヘッダ通知コード。
    /// </summary>
    public static class HDN
    {
        /// <summary></summary>
        public const int HDN_FIRST = (0 - 300);       // header
        /// <summary></summary>
        public const int HDN_LAST = (0 - 399);
        /// <summary></summary>
        public const int HDN_ITEMCHANGINGA = (HDN_FIRST - 0);
        /// <summary></summary>
        public const int HDN_ITEMCHANGINGW = (HDN_FIRST - 20);
        /// <summary></summary>
        public const int HDN_ITEMCHANGEDA = (HDN_FIRST - 1);
        /// <summary></summary>
        public const int HDN_ITEMCHANGEDW = (HDN_FIRST - 21);
        /// <summary></summary>
        public const int HDN_ITEMCLICKA = (HDN_FIRST - 2);
        /// <summary></summary>
        public const int HDN_ITEMCLICKW = (HDN_FIRST - 22);
        /// <summary></summary>
        public const int HDN_ITEMDBLCLICKA = (HDN_FIRST - 3);
        /// <summary></summary>
        public const int HDN_ITEMDBLCLICKW = (HDN_FIRST - 23);
        /// <summary></summary>
        public const int HDN_DIVIDERDBLCLICKA = (HDN_FIRST - 5);
        /// <summary></summary>
        public const int HDN_DIVIDERDBLCLICKW = (HDN_FIRST - 25);
        /// <summary></summary>
        public const int HDN_BEGINTRACKA = (HDN_FIRST - 6);
        /// <summary></summary>
        public const int HDN_BEGINTRACKW = (HDN_FIRST - 26);
        /// <summary></summary>
        public const int HDN_ENDTRACKA = (HDN_FIRST - 7);
        /// <summary></summary>
        public const int HDN_ENDTRACKW = (HDN_FIRST - 27);
        /// <summary></summary>
        public const int HDN_TRACKA = (HDN_FIRST - 8);
        /// <summary></summary>
        public const int HDN_TRACKW = (HDN_FIRST - 28);
        /// <summary></summary>
        public const int HDN_GETDISPINFOA = (HDN_FIRST - 9);
        /// <summary></summary>
        public const int HDN_GETDISPINFOW = (HDN_FIRST - 29);
        /// <summary></summary>
        public const int HDN_BEGINDRAG = (HDN_FIRST - 10);
        /// <summary></summary>
        public const int HDN_ENDDRAG = (HDN_FIRST - 11);
        /// <summary></summary>
        public const int HDN_FILTERCHANGE = (HDN_FIRST - 12);
        /// <summary></summary>
        public const int HDN_FILTERBTNCLICK = (HDN_FIRST - 13);
    }
    #endregion

    #region HDI
    /// <summary>
    /// ヘッダ項目マスク。
    /// </summary>
    public static class HDI
    {
        /// <summary></summary>
        public const int HDI_WIDTH = 0x0001;
        /// <summary></summary>
        public const int HDI_HEIGHT = HDI_WIDTH;
        /// <summary></summary>
        public const int HDI_TEXT = 0x0002;
        /// <summary></summary>
        public const int HDI_FORMAT = 0x0004;
        /// <summary></summary>
        public const int HDI_LPARAM = 0x0008;
        /// <summary></summary>
        public const int HDI_BITMAP = 0x0010;
        /// <summary></summary>
        public const int HDI_IMAGE = 0x0020;
        /// <summary></summary>
        public const int HDI_DI_SETITEM = 0x0040;
        /// <summary></summary>
        public const int HDI_ORDER = 0x0080;
        /// <summary></summary>
        public const int HDI_FILTER = 0x0100;
    }
    #endregion

    #region HDF
    /// <summary>
    /// ヘッダ項目フォーマット。
    /// </summary>
    public static class HDF
    {
        /// <summary></summary>
        public const int HDF_LEFT = 0x0000;
        /// <summary></summary>
        public const int HDF_RIGHT = 0x0001;
        /// <summary></summary>
        public const int HDF_CENTER = 0x0002;
        /// <summary></summary>
        public const int HDF_JUSTIFYMASK = 0x0003;
        /// <summary></summary>
        public const int HDF_RTLREADING = 0x0004;
        /// <summary></summary>
        public const int HDF_OWNERDRAW = 0x8000;
        /// <summary></summary>
        public const int HDF_STRING = 0x4000;
        /// <summary></summary>
        public const int HDF_BITMAP = 0x2000;
        /// <summary></summary>
        public const int HDF_BITMAP_ON_RIGHT = 0x1000;
        /// <summary></summary>
        public const int HDF_IMAGE = 0x0800;
        /// <summary></summary>
        public const int HDF_SORTUP = 0x0400;
        /// <summary></summary>
        public const int HDF_SORTDOWN = 0x0200;
    }
    #endregion

    #region TVS
    /// <summary>
    /// ツリービュースタイル。
    /// </summary>
    public static class TVS
    {
        /// <summary></summary>
        public const int TVS_HASBUTTONS = 0x0001;
        /// <summary></summary>
        public const int TVS_HASLINES = 0x0002;
        /// <summary></summary>
        public const int TVS_LINESATROOT = 0x0004;
        /// <summary></summary>
        public const int TVS_EDITLABELS = 0x0008;
        /// <summary></summary>
        public const int TVS_DISABLEDRAGDROP = 0x0010;
        /// <summary></summary>
        public const int TVS_SHOWSELALWAYS = 0x0020;
        /// <summary></summary>
        public const int TVS_RTLREADING = 0x0040;
        /// <summary></summary>
        public const int TVS_NOTOOLTIPS = 0x0080;
        /// <summary></summary>
        public const int TVS_CHECKBOXES = 0x0100;
        /// <summary></summary>
        public const int TVS_TRACKSELECT = 0x0200;
        /// <summary></summary>
        public const int TVS_SINGLEEXPAND = 0x0400;
        /// <summary></summary>
        public const int TVS_INFOTIP = 0x0800;
        /// <summary></summary>
        public const int TVS_FULLROWSELECT = 0x1000;
        /// <summary></summary>
        public const int TVS_NOSCROLL = 0x2000;
        /// <summary></summary>
        public const int TVS_NONEVENHEIGHT = 0x4000;
        /// <summary></summary>
        public const int TVS_NOHSCROLL = 0x8000;  // TVS_NOSCROLL overrides this
    }
    #endregion

    #region TVM
    /// <summary>
    /// ツリービューメッセージ。
    /// </summary>
    public static class TVM
    {
        /// <summary></summary>
        public const int TV_FIRST = 0x1100;      // TreeView messages
        /// <summary></summary>
        public const int TVM_INSERTITEMA = (TV_FIRST + 0);
        /// <summary></summary>
        public const int TVM_INSERTITEMW = (TV_FIRST + 50);
        /// <summary></summary>
        public const int TVM_DELETEITEM = (TV_FIRST + 1);
        /// <summary></summary>
        public const int TVM_EXPAND = (TV_FIRST + 2);
        /// <summary></summary>
        public const int TVM_GETITEMRECT = (TV_FIRST + 4);
        /// <summary></summary>
        public const int TVM_GETCOUNT = (TV_FIRST + 5);
        /// <summary></summary>
        public const int TVM_GETINDENT = (TV_FIRST + 6);
        /// <summary></summary>
        public const int TVM_SETINDENT = (TV_FIRST + 7);
        /// <summary></summary>
        public const int TVM_GETIMAGELIST = (TV_FIRST + 8);
        /// <summary></summary>
        public const int TVM_SETIMAGELIST = (TV_FIRST + 9);
        /// <summary></summary>
        public const int TVM_GETNEXTITEM = (TV_FIRST + 10);
        /// <summary></summary>
        public const int TVM_SELECTITEM = (TV_FIRST + 11);
        /// <summary></summary>
        public const int TVM_GETITEMA = (TV_FIRST + 12);
        /// <summary></summary>
        public const int TVM_GETITEMW = (TV_FIRST + 62);
        /// <summary></summary>
        public const int TVM_SETITEMA = (TV_FIRST + 13);
        /// <summary></summary>
        public const int TVM_SETITEMW = (TV_FIRST + 63);
        /// <summary></summary>
        public const int TVM_EDITLABELA = (TV_FIRST + 14);
        /// <summary></summary>
        public const int TVM_EDITLABELW = (TV_FIRST + 65);
        /// <summary></summary>
        public const int TVM_GETEDITCONTROL = (TV_FIRST + 15);
        /// <summary></summary>
        public const int TVM_GETVISIBLECOUNT = (TV_FIRST + 16);
        /// <summary></summary>
        public const int TVM_HITTEST = (TV_FIRST + 17);
        /// <summary></summary>
        public const int TVM_CREATEDRAGIMAGE = (TV_FIRST + 18);
        /// <summary></summary>
        public const int TVM_SORTCHILDREN = (TV_FIRST + 19);
        /// <summary></summary>
        public const int TVM_ENSUREVISIBLE = (TV_FIRST + 20);
        /// <summary></summary>
        public const int TVM_SORTCHILDRENCB = (TV_FIRST + 21);
        /// <summary></summary>
        public const int TVM_ENDEDITLABELNOW = (TV_FIRST + 22);
        /// <summary></summary>
        public const int TVM_GETISEARCHSTRINGA = (TV_FIRST + 23);
        /// <summary></summary>
        public const int TVM_GETISEARCHSTRINGW = (TV_FIRST + 64);
        /// <summary></summary>
        public const int TVM_SETTOOLTIPS = (TV_FIRST + 24);
        /// <summary></summary>
        public const int TVM_GETTOOLTIPS = (TV_FIRST + 25);
        /// <summary></summary>
        public const int TVM_SETINSERTMARK = (TV_FIRST + 26);
        /// <summary></summary>
        public const int TVM_SETITEMHEIGHT = (TV_FIRST + 27);
        /// <summary></summary>
        public const int TVM_GETITEMHEIGHT = (TV_FIRST + 28);
        /// <summary></summary>
        public const int TVM_SETBKCOLOR = (TV_FIRST + 29);
        /// <summary></summary>
        public const int TVM_SETTEXTCOLOR = (TV_FIRST + 30);
        /// <summary></summary>
        public const int TVM_GETBKCOLOR = (TV_FIRST + 31);
        /// <summary></summary>
        public const int TVM_GETTEXTCOLOR = (TV_FIRST + 32);
        /// <summary></summary>
        public const int TVM_SETSCROLLTIME = (TV_FIRST + 33);
        /// <summary></summary>
        public const int TVM_GETSCROLLTIME = (TV_FIRST + 34);
        /// <summary></summary>
        public const int TVM_SETINSERTMARKCOLOR = (TV_FIRST + 37);
        /// <summary></summary>
        public const int TVM_GETINSERTMARKCOLOR = (TV_FIRST + 38);
        /// <summary></summary>
        public const int TVM_GETITEMSTATE = (TV_FIRST + 39);
        /// <summary></summary>
        public const int TVM_SETLINECOLOR = (TV_FIRST + 40);
        /// <summary></summary>
        public const int TVM_GETLINECOLOR = (TV_FIRST + 41);
        /// <summary></summary>
        public const int TVM_MAPACCIDTOHTREEITEM = (TV_FIRST + 42);
        /// <summary></summary>
        public const int TVM_MAPHTREEITEMTOACCID = (TV_FIRST + 43);
    }
    #endregion

    #region TVHT
    /// <summary>
    /// ツリービューヒットテストフラグ。
    /// </summary>
    public static class TVHT
    {
        /// <summary></summary>
        public const int TVHT_NOWHERE = 0x0001;
        /// <summary></summary>
        public const int TVHT_ONITEMICON = 0x0002;
        /// <summary></summary>
        public const int TVHT_ONITEMLABEL = 0x0004;
        /// <summary></summary>
        public const int TVHT_ONITEM = (TVHT_ONITEMICON | TVHT_ONITEMLABEL | TVHT_ONITEMSTATEICON);
        /// <summary></summary>
        public const int TVHT_ONITEMINDENT = 0x0008;
        /// <summary></summary>
        public const int TVHT_ONITEMBUTTON = 0x0010;
        /// <summary></summary>
        public const int TVHT_ONITEMRIGHT = 0x0020;
        /// <summary></summary>
        public const int TVHT_ONITEMSTATEICON = 0x0040;
        /// <summary></summary>
        public const int TVHT_ABOVE = 0x0100;
        /// <summary></summary>
        public const int TVHT_BELOW = 0x0200;
        /// <summary></summary>
        public const int TVHT_TORIGHT = 0x0400;
        /// <summary></summary>
        public const int TVHT_TOLEFT = 0x0800;
    }
    #endregion

    #region TBS
    /// <summary>
    /// トラックバースタイル。
    /// </summary>
    public static class TBS
    {
        /// <summary></summary>
        public const int TBS_AUTOTICKS = 0x0001;
        /// <summary></summary>
        public const int TBS_VERT = 0x0002;
        /// <summary></summary>
        public const int TBS_HORZ = 0x0000;
        /// <summary></summary>
        public const int TBS_TOP = 0x0004;
        /// <summary></summary>
        public const int TBS_BOTTOM = 0x0000;
        /// <summary></summary>
        public const int TBS_LEFT = 0x0004;
        /// <summary></summary>
        public const int TBS_RIGHT = 0x0000;
        /// <summary></summary>
        public const int TBS_BOTH = 0x0008;
        /// <summary></summary>
        public const int TBS_NOTICKS = 0x0010;
        /// <summary></summary>
        public const int TBS_ENABLESELRANGE = 0x0020;
        /// <summary></summary>
        public const int TBS_FIXEDLENGTH = 0x0040;
        /// <summary></summary>
        public const int TBS_NOTHUMB = 0x0080;
        /// <summary></summary>
        public const int TBS_TOOLTIPS = 0x0100;
        /// <summary></summary>
        public const int TBS_REVERSED = 0x0200; // Accessibility hint: the smaller number (usually the min value) means "high" and the larger number (usually the max value) means "low"
        /// <summary></summary>
        public const int TBS_DOWNISLEFT = 0x0400; // Down=Left and Up=Right (default is Down=Right and Up=Left)
    }
    #endregion

    #region TBM
    /// <summary>
    /// トラックバーメッセージ。
    /// </summary>
    public static class TBM
    {
        /// <summary></summary>
        public const int TBM_GETPOS = (WM.WM_USER);
        /// <summary></summary>
        public const int TBM_GETRANGEMIN = (WM.WM_USER + 1);
        /// <summary></summary>
        public const int TBM_GETRANGEMAX = (WM.WM_USER + 2);
        /// <summary></summary>
        public const int TBM_GETTIC = (WM.WM_USER + 3);
        /// <summary></summary>
        public const int TBM_SETTIC = (WM.WM_USER + 4);
        /// <summary></summary>
        public const int TBM_SETPOS = (WM.WM_USER + 5);
        /// <summary></summary>
        public const int TBM_SETRANGE = (WM.WM_USER + 6);
        /// <summary></summary>
        public const int TBM_SETRANGEMIN = (WM.WM_USER + 7);
        /// <summary></summary>
        public const int TBM_SETRANGEMAX = (WM.WM_USER + 8);
        /// <summary></summary>
        public const int TBM_CLEARTICS = (WM.WM_USER + 9);
        /// <summary></summary>
        public const int TBM_SETSEL = (WM.WM_USER + 10);
        /// <summary></summary>
        public const int TBM_SETSELSTART = (WM.WM_USER + 11);
        /// <summary></summary>
        public const int TBM_SETSELEND = (WM.WM_USER + 12);
        /// <summary></summary>
        public const int TBM_GETPTICS = (WM.WM_USER + 14);
        /// <summary></summary>
        public const int TBM_GETTICPOS = (WM.WM_USER + 15);
        /// <summary></summary>
        public const int TBM_GETNUMTICS = (WM.WM_USER + 16);
        /// <summary></summary>
        public const int TBM_GETSELSTART = (WM.WM_USER + 17);
        /// <summary></summary>
        public const int TBM_GETSELEND = (WM.WM_USER + 18);
        /// <summary></summary>
        public const int TBM_CLEARSEL = (WM.WM_USER + 19);
        /// <summary></summary>
        public const int TBM_SETTICFREQ = (WM.WM_USER + 20);
        /// <summary></summary>
        public const int TBM_SETPAGESIZE = (WM.WM_USER + 21);
        /// <summary></summary>
        public const int TBM_GETPAGESIZE = (WM.WM_USER + 22);
        /// <summary></summary>
        public const int TBM_SETLINESIZE = (WM.WM_USER + 23);
        /// <summary></summary>
        public const int TBM_GETLINESIZE = (WM.WM_USER + 24);
        /// <summary></summary>
        public const int TBM_GETTHUMBRECT = (WM.WM_USER + 25);
        /// <summary></summary>
        public const int TBM_GETCHANNELRECT = (WM.WM_USER + 26);
        /// <summary></summary>
        public const int TBM_SETTHUMBLENGTH = (WM.WM_USER + 27);
        /// <summary></summary>
        public const int TBM_GETTHUMBLENGTH = (WM.WM_USER + 28);
        /// <summary></summary>
        public const int TBM_SETTOOLTIPS = (WM.WM_USER + 29);
        /// <summary></summary>
        public const int TBM_GETTOOLTIPS = (WM.WM_USER + 30);
        /// <summary></summary>
        public const int TBM_SETTIPSIDE = (WM.WM_USER + 31);
    }
    #endregion

    #region TB
    /// <summary>
    /// トラックバー通知コード。
    /// </summary>
    public static class TB
    {
        /// <summary></summary>
        public const int TB_LINEUP = 0;
        /// <summary></summary>
        public const int TB_LINEDOWN = 1;
        /// <summary></summary>
        public const int TB_PAGEUP = 2;
        /// <summary></summary>
        public const int TB_PAGEDOWN = 3;
        /// <summary></summary>
        public const int TB_THUMBPOSITION = 4;
        /// <summary></summary>
        public const int TB_THUMBTRACK = 5;
        /// <summary></summary>
        public const int TB_TOP = 6;
        /// <summary></summary>
        public const int TB_BOTTOM = 7;
        /// <summary></summary>
        public const int TB_ENDTRACK = 8;
    }
    #endregion

    //---------------------------------------------------------------------
    // ShellAPI.h
    //---------------------------------------------------------------------
    #region SHGFI
    /// <summary>
    /// SHGetFileInfo() パラメタ。
    /// </summary>
    public static class SHGFI
    {
        /// <summary></summary>
        public const int SHGFI_ICON = 0x000000100;                  // get icon
        /// <summary></summary>
        public const int SHGFI_DISPLAYNAME = 0x000000200;           // get display name
        /// <summary></summary>
        public const int SHGFI_TYPENAME = 0x000000400;              // get type name
        /// <summary></summary>
        public const int SHGFI_ATTRIBUTES = 0x000000800;            // get attributes
        /// <summary></summary>
        public const int SHGFI_ICONLOCATION = 0x000001000;          // get icon location
        /// <summary></summary>
        public const int SHGFI_EXETYPE = 0x000002000;               // return exe type
        /// <summary></summary>
        public const int SHGFI_SYSICONINDEX = 0x000004000;          // get system icon index
        /// <summary></summary>
        public const int SHGFI_LINKOVERLAY = 0x000008000;           // put a link overlay on icon
        /// <summary></summary>
        public const int SHGFI_SELECTED = 0x000010000;              // show icon in selected state
        /// <summary></summary>
        public const int SHGFI_ATTR_SPECIFIED = 0x000020000;        // get only specified attributes
        /// <summary></summary>
        public const int SHGFI_LARGEICON = 0x000000000;             // get large icon
        /// <summary></summary>
        public const int SHGFI_SMALLICON = 0x000000001;             // get small icon
        /// <summary></summary>
        public const int SHGFI_OPENICON = 0x000000002;              // get open icon
        /// <summary></summary>
        public const int SHGFI_SHELLICONSIZE = 0x000000004;         // get shell size icon
        /// <summary></summary>
        public const int SHGFI_PIDL = 0x000000008;                  // pszPath is a pidl
        /// <summary></summary>
        public const int SHGFI_USEFILEATTRIBUTES = 0x000000010;     // use passed dwFileAttribute
        /// <summary></summary>
        public const int SHGFI_ADDOVERLAYS = 0x000000020;           // apply the appropriate overlays
        /// <summary></summary>
        public const int SHGFI_OVERLAYINDEX = 0x000000040;          // Get the index of the overlay in the upper 8 bits of the iIcon
    }
    #endregion

    //---------------------------------------------------------------------
    // OleCtl.h
    //---------------------------------------------------------------------
    #region OCM
    /// <summary>
    /// Reflected ウィンドウメッセージ。
    /// </summary>
    public static class OCM
    {
        /// <summary></summary>
        public const int OCM__BASE = (WM.WM_USER + 0x1c00);
        /// <summary></summary>
        public const int OCM_COMMAND = (OCM__BASE + WM.WM_COMMAND);
        /// <summary></summary>
        public const int OCM_CTLCOLORBTN = (OCM__BASE + WM.WM_CTLCOLORBTN);
        /// <summary></summary>
        public const int OCM_CTLCOLOREDIT = (OCM__BASE + WM.WM_CTLCOLOREDIT);
        /// <summary></summary>
        public const int OCM_CTLCOLORDLG = (OCM__BASE + WM.WM_CTLCOLORDLG);
        /// <summary></summary>
        public const int OCM_CTLCOLORLISTBOX = (OCM__BASE + WM.WM_CTLCOLORLISTBOX);
        /// <summary></summary>
        public const int OCM_CTLCOLORMSGBOX = (OCM__BASE + WM.WM_CTLCOLORMSGBOX);
        /// <summary></summary>
        public const int OCM_CTLCOLORSCROLLBAR = (OCM__BASE + WM.WM_CTLCOLORSCROLLBAR);
        /// <summary></summary>
        public const int OCM_CTLCOLORSTATIC = (OCM__BASE + WM.WM_CTLCOLORSTATIC);
        /// <summary></summary>
        public const int OCM_CTLCOLOR = (OCM__BASE + WM.WM_CTLCOLOR);
        /// <summary></summary>
        public const int OCM_DRAWITEM = (OCM__BASE + WM.WM_DRAWITEM);
        /// <summary></summary>
        public const int OCM_MEASUREITEM = (OCM__BASE + WM.WM_MEASUREITEM);
        /// <summary></summary>
        public const int OCM_DELETEITEM = (OCM__BASE + WM.WM_DELETEITEM);
        /// <summary></summary>
        public const int OCM_VKEYTOITEM = (OCM__BASE + WM.WM_VKEYTOITEM);
        /// <summary></summary>
        public const int OCM_CHARTOITEM = (OCM__BASE + WM.WM_CHARTOITEM);
        /// <summary></summary>
        public const int OCM_COMPAREITEM = (OCM__BASE + WM.WM_COMPAREITEM);
        /// <summary></summary>
        public const int OCM_HSCROLL = (OCM__BASE + WM.WM_HSCROLL);
        /// <summary></summary>
        public const int OCM_VSCROLL = (OCM__BASE + WM.WM_VSCROLL);
        /// <summary></summary>
        public const int OCM_PARENTNOTIFY = (OCM__BASE + WM.WM_PARENTNOTIFY);
        /// <summary></summary>
        public const int OCM_NOTIFY = (OCM__BASE + WM.WM_NOTIFY);
    }
    #endregion

    //---------------------------------------------------------------------
    // その他
    //---------------------------------------------------------------------
    #region Constants
    /// <summary>
    /// 定数値。
    /// </summary>
    public static class Constants
    {
        /// <summary></summary>
        public const int WHEEL_DELTA = 120;
        /// <summary></summary>
        public const int MAX_PATH = 260;
    }
    #endregion
}
