﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace NintendoWare.SoundFoundation.Core.Parameters
{
    ///--------------------------------------------------------------------------
    /// <summary>
    ///
    /// </summary>
    public class XmlParameterDeserializer : XmlParameterSerializerBase
    {
        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void Execute(XmlElement xmlCardinalElement, IParameterDictionary dictionary, IParameterFilter filter)
        {
            string name = null;
            string type = null;
            string value = null;

            if (xmlCardinalElement.Name != ElementNodeName)
            {
                return;
            }

            foreach (XmlElement xmlElement in
                     xmlCardinalElement.SelectNodes(ElementLeafName))
            {

                if (xmlElement.HasAttribute("Name") == false ||
                    xmlElement.HasAttribute("Type") == false ||
                    xmlElement.HasAttribute("Value") == false)
                {
                    //Exceptionのが良い？
                    continue;
                }

                try
                {
                    name = xmlElement.GetAttribute("Name");
                    type = xmlElement.GetAttribute("Type");
                    value = xmlElement.GetAttribute("Value");

                    if (filter != null)
                    {
                        if (filter.Filter(name) == false)
                        {
                            continue;
                        }
                    }

                    if (!dictionary.ContainsKey(name))
                    {
                        dictionary.AddValue(name, CreateParameterValue(type));
                    }

                    dictionary[name].Parse(value);
                }

                catch
                {
                    //Exceptionのが良い？
                }
            }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        private IParameterValue CreateParameterValue(string type)
        {

            IParameterValueFactory factory = null;

            if ((factory = Factorys[type]) == null)
            {
                return null;
            }

            return factory.Create();
        }
    }
}
