﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.IO
{
    using System;
    using System.IO;

    public static class PathUtility
    {
        public static string GetFullPath(this string path)
        {
            string sourcePath = string.IsNullOrEmpty(path) ? "." : path;

            // Path.GetFullPath() を直接使用すると
            // ../ 等を含む冗長なパス長に制約がかかるため、
            // Uri.LocalPath で先に最短パスに変換してから、
            // Path.GetFullPath() にてパス長を検証しています。
            // ただし、path が相対パスの場合は Uri で例外が発生するため、
            // path が絶対パスの場合にのみ実行します。
            if (Path.IsPathRooted(path))
            {
                sourcePath = new Uri(path).LocalPath;
            }

            return Path.GetFullPath(sourcePath);
        }
    }
}
