﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// コンバート依存関係に関わる機能を提供します。
    /// </summary>
    public interface ISoundProjectConvertDependencyService
    {
        /// <summary>
        /// 関連付けられたサウンドプロジェクトサービスを取得します。
        /// </summary>
        SoundProjectService SoundProjectService { get; }

        /// <summary>
        /// サウンドプロジェクトサービスを関連付けます。
        /// </summary>
        /// <param name="projectService">サウンドプロジェクトサービスを指定します。</param>
        void Attach(SoundProjectService projectService);

        /// <summary>
        /// サウンドプロジェクトサービスの関連付けを解除します。
        /// </summary>
        void Detach();

        /// <summary>
        /// 関連付けられたサウンドプロジェクトのバイナリ情報を更新します。
        /// </summary>
        void UpdateSoundProjectBinaryInformations();

        /// <summary>
        /// バンクのバイナリ情報を更新します。
        /// </summary>
        void UpdateBankBinaryInformations(BankService bankService);

        /// <summary>
        /// コンポーネントに対応するバイナリファイルパスを取得します。
        /// </summary>
        /// <param name="component">コンポーネント。</param>
        /// <returns>バイナリファイルパス。</returns>
        string[] GetBinaryFilePath(Component component);
    }
}
