﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;

    /// <summary>
    /// IConversionProcessor の処理状態に関するイベントのパラメータを格納します。
    /// </summary>
    public class ConversionProcessStateEventArgs : EventArgs
    {
        private readonly ConversionProcessState state = ConversionProcessState.NotReady;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="state">IConversionProcessor の状態を指定します。</param>
        public ConversionProcessStateEventArgs(ConversionProcessState state)
        {
            this.state = state;
        }

        /// <summary>
        /// IConversionProcessor の状態を取得します。
        /// </summary>
        public ConversionProcessState State
        {
            get { return this.state; }
        }
    }
}
