﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    /// <summary>
    /// IConversionProcessor による処理の状態を表します。
    /// </summary>
    public enum ConversionProcessState
    {
        /// <summary>
        /// 実行の準備ができていないことを表します。
        /// </summary>
        NotReady,

        /// <summary>
        /// 実行準備が完了したことを表します。
        /// </summary>
        Ready,

        /// <summary>
        /// 実行中であることを表します。
        /// </summary>
        Running,

        /// <summary>
        /// 実行済みであることを表します。
        /// </summary>
        Done,

        /// <summary>
        /// 異常終了したことを表します。
        /// </summary>
        Error,
    }
}
