﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using Core.IO;
    using Logs;
    using ToolDevelopmentKit;

    public class ConversionContext
    {
        private ConversionTraits traits;
        private string projectFilePath;

        private ILogger logger = new Logger();
        private HashSet<IConversionProcessor> conversionProcessors = new HashSet<IConversionProcessor>();

        public ConversionContext(ConversionTraits traits, string projectFilePath)
        {
            Ensure.Argument.NotNull(traits);
            this.traits = traits;
            this.projectFilePath = projectFilePath;
        }

        public ConversionContext(ConversionTraits traits)
            : this(traits, string.Empty)
        {
        }

        public ConversionTraits Traits
        {
            get { return this.traits; }
        }

        public ILogger Logger
        {
            get { return this.logger; }
            set { this.logger = value; }
        }

        public bool IsFailed
        {
            get { return this.logger.HasLineLevel(OutputLevel.Error); }
        }

        public ICollection<IConversionProcessor> ConversionProcessors
        {
            get { return this.conversionProcessors; }
        }

        public string ProjectFilePath
        {
            get
            {
                return this.projectFilePath;
            }
        }

        public BinaryReader CreateBinaryReader(Stream stream)
        {
            return this.Traits.IsLittleEndian ?
                LittleEndianBinaryReader.Create(stream) : BigEndianBinaryReader.Create(stream);
        }

        public BinaryWriter CreateBinaryWriter(Stream stream)
        {
            return this.Traits.IsLittleEndian ?
                LittleEndianBinaryWriter.Create(stream) : BigEndianBinaryWriter.Create(stream);
        }
    }
}
