﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareReport
{
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Projects;

    internal static class SoundSetItemsAccessor
    {
        public static IEnumerable<SoundSetItem> EnumerateItems(this SoundSet soundSet, bool isIgnoreDisableItems)
        {
            foreach (SoundSetItem itemPack in soundSet.Children)
            {
                if (itemPack is WaveSoundSetPack || itemPack is SequenceSoundSetPack)
                {
                    foreach (SoundSetItem itemSet in itemPack.Children)
                    {
                        if (isIgnoreDisableItems && !itemSet.IsEnabled)
                        {
                            continue;
                        }

                        yield return itemSet;

                        foreach (SoundSetItem item in itemSet.Children)
                        {
                            if (isIgnoreDisableItems && !item.IsEnabled)
                            {
                                continue;
                            }

                            yield return item;
                        }
                    }
                }
                else
                {
                    foreach (SoundSetItem item in itemPack.Children)
                    {
                        if (isIgnoreDisableItems && !item.IsEnabled)
                        {
                            continue;
                        }

                        yield return item;
                    }
                }
            }
        }
    }
}
