﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;

    /// <summary>
    /// サウンドプロジェクトコンバート特性を格納します。
    /// </summary>
    public class SoundProjectConversionTraits : ComponentConversionTraits
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        public SoundProjectConversionTraits(bool isLittleEndian)
            : base(isLittleEndian)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        /// <param name="maxFilePath">ファイルパスの最大長を指定します。</param>
        public SoundProjectConversionTraits(bool isLittleEndian, int maxFilePath)
            : base(isLittleEndian, maxFilePath)
        {
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// ビルトイン波形プリプロセス exe ファイルのパスを取得または設定します。
        /// </summary>
        public string BuiltInWavePreprocessExePath { get; set; }

        /// <summary>
        /// Smfコンバータexeファイルのパスを取得または設定します。
        /// </summary>
        public string SmfConverterPath { get; set; }

        /// <summary>
        /// シーケンスサウンドテキストコンバータexeファイルのパスを取得または設定します。
        /// </summary>
        public string SequenceSoundTextConverterPath { get; set; }

        // HACK : マルチプラットフォーム対応のために暫定的に追加しました。
        //        これがあれば SequenceSoundTextConverterPath は不要かもしれません。
        public ISequenceSoundTextConverter SequenceSoundTextConverter { get; set; }

        // HACK : マルチプラットフォーム対応のために暫定的に追加しました。
        //        これがあれば SmfConverterPath は不要かもしれません。
        public ISmfConverter SmfConverter { get; set; }

        // HACK : とりあえずバイナリ関連オブジェクトはここに追加していますが、
        //        あとで整理が必要そうです。
        public ISequenceSoundBinaryReader SequenceSoundBinaryReader { get; set; }

        /// <summary>
        /// 新しいウェーブサウンドバイナリ利用の有無を取得または設定します。
        /// </summary>
        public bool IsWaveSound2BinaryEnabled { get; set; }
    }
}
