﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// コンポーネントのコンバート特性を格納します。
    /// </summary>
    public abstract class ComponentConversionTraits : ConversionTraits
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        public ComponentConversionTraits(bool isLittleEndian)
            : base(isLittleEndian)
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="isLittleEndian">
        /// リトルエンディアンの場合は true、
        /// ビッグエンディアンの場合は false を指定します。
        /// </param>
        /// <param name="maxFilePath">ファイルパスの最大長を指定します。</param>
        public ComponentConversionTraits(bool isLittleEndian, int maxFilePath)
            : base(isLittleEndian, maxFilePath)
        {
            this.IntermediateOutputTraits = new SoundIntermediateOutputTraits();
            this.BinaryOutputTraits = new SoundBinaryOutputTraits();
            this.BinaryFileInfo = new BinaryFileInfo();
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// サウンド中間出力の特性を取得します。
        /// </summary>
        public SoundIntermediateOutputTraits IntermediateOutputTraits { get; set; }

        /// <summary>
        /// サウンドバイナリ出力の特性を取得します。
        /// </summary>
        public SoundBinaryOutputTraits BinaryOutputTraits { get; set; }

        /// <summary>
        /// バイナリファイル情報を取得します。
        /// </summary>
        public BinaryFileInfo BinaryFileInfo { get; set; }
    }
}
