﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.SoundFoundation.Logs;
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    /// サウンドプロジェクトをコンバートし、サウンドアーカイブバイナリを生成します。
    /// </summary>
    public interface ISoundProjectConverter
    {
        event EventHandler<OutputLineEventArgs> LineOutput;

        event EventHandler ConversionCompleted;

        event EventHandler<CustomConversionEventArgs> PreConvert;

        event EventHandler<CustomConversionEventArgs> PostConvert;

        //-----------------------------------------------------------------

        SoundProjectConversionTraits Traits { get; }

        SoundProjectConversionSettings Settings { get; }

        bool IsSucceeded { get; }

        bool IsFailed { get; }

        bool IsCanceled { get; }

        int ProgressMax { get; }

        int ProgressCurrent { get; }

        //-----------------------------------------------------------------

        void Run(SoundProjectService projectService, IEnumerable<BankService> bankServices);

        void Run(
            SoundProjectService projectService,
            IEnumerable<BankService> bankServices,
            Func<string, bool> isCacheUse);

        void Run(
            SoundProjectService projectService,
            IEnumerable<BankService> bankServices,
            Func<string, bool> isCacheUse,
            bool isForced);

        void RunParts(
            SoundProjectService projectService,
            IEnumerable<BankService> bankServices,
            IEnumerable<SoundSetItem> soundSetItems,
            string outputDirectoryPath,
            bool doGarbageCorrection);

        void Cancel();

        void Wait();
    }
}
