﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// キーバインディング情報を保持します。
    /// </summary>
    public struct KeyBinding
    {
        private KeyStroke[] _keyStrokes;    // キーストローク
        private Command _command;       // コマンド

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="keyStrokes">キーストローク。</param>
        /// <param name="command">コマンド。</param>
        public KeyBinding(KeyStroke[] keyStrokes, Command command)
        {
            if (null == keyStrokes) { throw new ArgumentNullException("keyStrokes"); }
            if (null == command) { throw new ArgumentNullException("command"); }

            _keyStrokes = keyStrokes;
            _command = command;
        }

        /// <summary>
        /// キーストロークを取得します。
        /// </summary>
        public KeyStroke[] KeyStrokes
        {
            get { return _keyStrokes; }
        }

        /// <summary>
        /// コマンドを取得します。
        /// </summary>
        public Command Command
        {
            get { return _command; }
        }
    }
}
