﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// コマンドのコレクションを管理します。
    /// </summary>
    public interface ICommandCollection : IEnumerable<Command>
    {
        /// <summary>
        /// 指定コマンドIDを持つコマンドを取得します。
        /// </summary>
        /// <param name="commandID">コマンドID。</param>
        /// <returns>コマンド。</returns>
        Command this[string commandID] { get; }

        /// <summary>
        /// 指定コマンドIDを持つコマンドが存在するかどうか調べます。
        /// </summary>
        /// <param name="commandID">コマンドID。</param>
        /// <returns>存在する場合は true、存在しない場合は false。</returns>
        bool Contains(string commandID);
    }
}
