﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using ToolDevelopmentKit;

    /// <summary>
    /// 値の型を変換します。
    /// </summary>
    public abstract class TypeConverter<TInput, TOutput> : ITypeConverter
    {
        /// <summary>
        /// 変換元の型を取得します。
        /// </summary>
        public Type InputType
        {
            get { return typeof(TInput); }
        }

        /// <summary>
        /// 変換後の型を取得します。
        /// </summary>
        public Type OutputType
        {
            get { return typeof(TOutput); }
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public object ConvertTo(object value)
        {
            Ensure.Argument.True(value is TInput);
            return ConvertTo((TInput)value);
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public object ConvertFrom(object value)
        {
            Ensure.Argument.True(value is TInput);
            return ConvertFrom((TInput)value);
        }

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public abstract TOutput ConvertTo(TInput value);

        /// <summary>
        /// 値を変換します。
        /// </summary>
        /// <param name="value">変換する値を指定します。</param>
        /// <returns>変換後の値を返します。</returns>
        public abstract TInput ConvertFrom(TOutput value);
    }
}
