﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    public class ObjectReference
    {
        private static ObjectReference nullInstance = new ObjectReference();

        private object obj;
        private ulong startAddress = ObjectReference.InvalidValue;
        private ulong endAddress = ObjectReference.InvalidValue;
        private ulong nextAddress = ObjectReference.InvalidValue;

        public static ObjectReference Null
        {
            get { return nullInstance; }
        }

        public static ulong InvalidValue
        {
            get { return ulong.MaxValue; }
        }

        public object Object
        {
            get { return this.obj; }
            set { this.obj = value; }
        }

        public ulong Address
        {
            get { return this.startAddress; }
        }

        public ulong Size
        {
            get
            {
                if (this.startAddress == ObjectReference.InvalidValue ||
                    this.endAddress == ObjectReference.InvalidValue)
                {
                    return ObjectReference.InvalidValue;
                }

                if (this.endAddress < this.startAddress)
                {
                    throw new Exception("internal exception.");
                }

                return this.endAddress - this.startAddress;
            }
        }

        public ulong OffsetToNext
        {
            get
            {
                if (this.startAddress == ObjectReference.InvalidValue ||
                    this.nextAddress == ObjectReference.InvalidValue)
                {
                    return ObjectReference.InvalidValue;
                }

                if (this.nextAddress < this.startAddress)
                {
                    throw new Exception("internal exception.");
                }

                return this.nextAddress - this.startAddress;
            }
        }

        public ulong StartAddress
        {
            get { return this.startAddress; }
            set { this.startAddress = value; }
        }

        public ulong EndAddress
        {
            get { return this.endAddress; }
            set { this.endAddress = value; }
        }

        public ulong NextAddress
        {
            get { return this.nextAddress; }
            set { this.nextAddress = value; }
        }
    }
}
