﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;

    internal class DomObjectAddressWriter : AddressWriter
    {
        public Type OffsetValueType { get; set; }

        protected override object GetInitialValue(DomWriterContext context)
        {
            if (null == context) { throw new ArgumentNullException("context"); }

            if (null == this.OffsetValueType)
            {
                return Address.MaxValue;
            }

            if (typeof(Byte) == this.OffsetValueType)
            {
                return Byte.MaxValue;
            }

            if (typeof(UInt16) == this.OffsetValueType)
            {
                return UInt16.MaxValue;
            }

            if (typeof(UInt32) == this.OffsetValueType)
            {
                return UInt32.MaxValue;
            }

            if (typeof(UInt64) == this.OffsetValueType)
            {
                return UInt64.MaxValue;
            }

            throw new Exception("invalid OffsetValueType");
        }

        protected override object GetValue(DomWriterContext context)
        {
            Ensure.Argument.NotNull(context);

            if (this.Reference == null)
            {
                return GetInitialValue(context);
            }

            if (this.Reference.Object == null)
            {
                return Address.MaxValue;
            }

            Address result = 0;

            if (this.OriginReference == null ||
                this.OriginReference.Object == null ||
                this.Reference.Address == ObjectReference.InvalidValue)
            {
                result = context.CreateAddress((ulong)this.Reference.Address);
            }
            else
            {
                result = context.CreateAddress(
                    (ulong)(this.Reference.Address - this.OriginReference.Address));
            }

            if (null == this.OffsetValueType)
            {
                return result;
            }

            if (typeof(Byte) == this.OffsetValueType)
            {
                return (Byte)result;
            }

            if (typeof(UInt16) == this.OffsetValueType)
            {
                return (UInt16)result;
            }

            if (typeof(UInt32) == this.OffsetValueType)
            {
                return (UInt32)result;
            }

            if (typeof(UInt64) == this.OffsetValueType)
            {
                return (UInt64)result;
            }

            throw new Exception("invalid OffsetValueType");
        }
    }
}
